/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.aristois.installer;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import me.deftware.aristois.installer.utils.Utils;
import me.deftware.aristois.installer.utils.VersionData;

public class InstallerAPI {
    static boolean donorBuild = false;
    static boolean universal = false;
    static HashMap<String, VersionData> versions = new HashMap();
    static String dataUrl = "https://maven.aristois.net/versions.json";
    static String aristoisMaven = "https://maven.aristois.net/";
    static JsonObject jsonData;

    public static void fetchData(boolean betaVersions) {
        try {
            System.out.printf("Fetching data from %s...\n", dataUrl);
            jsonData = new Gson().fromJson(Utils.get(dataUrl), JsonObject.class);
            InstallerAPI.populateVersions(betaVersions);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static String[] getMinecraftVersions() {
        String[] data = new String[versions.size()];
        ArrayList<String> versions = new ArrayList<String>();
        InstallerAPI.getVersions().keySet().forEach(k -> {
            if (k.split("\\.").length == 2) {
                k = k + ".0";
            }
            versions.add((String)k);
        });
        versions.sort(Comparator.comparingInt(value -> Integer.parseInt(value.replaceAll("\\.", ""))));
        Collections.reverse(versions);
        for (int i = 0; i < versions.size(); ++i) {
            data[i] = "Minecraft " + ((String)versions.get(i)).replace(".0", "");
        }
        return data;
    }

    public static void populateVersions(boolean betaVersions) {
        versions.clear();
        Arrays.stream((Object[])new Gson().fromJson((JsonElement)jsonData.get("versions").getAsJsonArray(), VersionData[].class)).forEach(v -> {
            if (!v.isBeta() || v.isBeta() && betaVersions) {
                versions.put(v.getVersion(), (VersionData)v);
            }
        });
    }

    public static boolean isDonorBuild() {
        return donorBuild;
    }

    public static boolean isUniversal() {
        return universal;
    }

    public static void setDonorBuild(boolean donorBuild) {
        InstallerAPI.donorBuild = donorBuild;
    }

    public static void setUniversal(boolean universal) {
        InstallerAPI.universal = universal;
    }

    public static HashMap<String, VersionData> getVersions() {
        return versions;
    }

    public static String getDataUrl() {
        return dataUrl;
    }

    public static String getAristoisMaven() {
        return aristoisMaven;
    }

    public static JsonObject getJsonData() {
        return jsonData;
    }
}

