/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.aristois.installer;

import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.UIManager;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import me.deftware.aristois.installer.InstallerAPI;
import me.deftware.aristois.installer.jsonbuilder.JsonBuilder;
import me.deftware.aristois.installer.ui.InstallerUI;
import me.deftware.aristois.installer.utils.VersionData;
import org.apache.commons.io.FileUtils;

public class Main {
    public static void main(String[] args) {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<String> dataUrl = parser.accepts("data").withOptionalArg();
        ArgumentAcceptingOptionSpec<String> mvnUrl = parser.accepts("mvn").withOptionalArg();
        ArgumentAcceptingOptionSpec<Boolean> betaVersions = parser.accepts("beta").withOptionalArg().ofType(Boolean.class).describedAs("bool");
        ArgumentAcceptingOptionSpec<Boolean> gen = parser.accepts("gen").withOptionalArg().ofType(Boolean.class).describedAs("bool");
        ArgumentAcceptingOptionSpec<Boolean> universal = parser.accepts("universal").withOptionalArg().ofType(Boolean.class).describedAs("bool");
        parser.allowsUnrecognizedOptions();
        OptionSet optionSet = parser.parse(args);
        if (optionSet.has(dataUrl)) {
            InstallerAPI.dataUrl = optionSet.valueOf(dataUrl);
            System.out.printf("Using custom data url %s\n", InstallerAPI.dataUrl);
        }
        if (optionSet.has(mvnUrl)) {
            InstallerAPI.aristoisMaven = optionSet.valueOf(mvnUrl);
            System.out.printf("Using custom data url %s\n", InstallerAPI.aristoisMaven);
        }
        if (optionSet.has(universal)) {
            InstallerAPI.universal = optionSet.valueOf(universal);
        }
        try {
            Attributes attr = new Manifest(((URLClassLoader)InstallerAPI.class.getClassLoader()).findResource("META-INF/MANIFEST.MF").openStream()).getMainAttributes();
            InstallerAPI.donorBuild = Boolean.parseBoolean(attr.getValue("donorBuild"));
        }
        catch (IOException E) {
            E.printStackTrace();
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            new Thread(() -> {
                try {
                    Thread.currentThread().setName("Version fetcher/parser");
                    InstallerAPI.fetchData(optionSet.has(betaVersions));
                    if (optionSet.has(gen)) {
                        InstallerAPI.donorBuild = false;
                        InstallerAPI.populateVersions(optionSet.has(betaVersions));
                        Main.genConfigs(args);
                        InstallerAPI.donorBuild = true;
                        InstallerAPI.populateVersions(optionSet.has(betaVersions));
                        Main.genConfigs(args);
                    } else {
                        InstallerAPI.populateVersions(optionSet.has(betaVersions));
                        InstallerUI.create().setVisible(true);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }).start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void genConfigs(String[] args) {
        File tempDir;
        System.out.println("== Generating launch configs for all supported versions ==");
        File path = new File(System.getProperty("user.dir") + File.separator + "configs" + File.separator);
        if (!path.exists() && !path.mkdirs()) {
            System.out.printf("Failed to create dir %s\n", path.getAbsolutePath());
        }
        if (!(tempDir = new File(path.getAbsolutePath() + File.separator + "versions" + File.separator + "temp")).mkdirs()) {
            System.out.printf("Could not create %s\n", tempDir.getAbsolutePath());
        }
        System.out.printf("Saving files to %s\n", path.getAbsolutePath());
        InstallerAPI.versions.values().forEach(v -> {
            JsonBuilder builder = v.getBuilder("", "Vanilla");
            System.out.println(builder.install(builder.build((VersionData)v), (VersionData)v, path.getAbsolutePath() + File.separator));
            try {
                File versionsFolder = new File(path.getAbsolutePath() + File.separator + "versions" + File.separator + v.getVersion() + "-Aristois");
                File tempDirVersion = new File(path.getAbsolutePath() + File.separator + "versions" + File.separator + "temp" + File.separator + v.getVersion() + "-Aristois");
                FileUtils.copyDirectory(versionsFolder, tempDirVersion);
                FileUtils.copyFile(new File(args[1]), new File(path.getAbsolutePath() + File.separator + "versions" + File.separator + "temp" + File.separator + v.getVersion() + "-Aristois" + File.separator + "Readme.txt"));
                Main.pack(tempDir.getAbsolutePath(), path.getAbsolutePath() + File.separator + "versions" + File.separator + v.getVersion() + "-Aristois-Latest" + (InstallerAPI.donorBuild ? "-D" : "") + ".zip");
                FileUtils.deleteDirectory(tempDirVersion);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
        try {
            FileUtils.deleteDirectory(tempDir);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void pack(String sourceDirPath, String zipFilePath) throws IOException {
        Path p = Files.createFile(Paths.get(zipFilePath, new String[0]), new FileAttribute[0]);
        try (ZipOutputStream zs = new ZipOutputStream(Files.newOutputStream(p, new OpenOption[0]));){
            Path pp = Paths.get(sourceDirPath, new String[0]);
            Files.walk(pp, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                ZipEntry zipEntry = new ZipEntry(pp.relativize((Path)path).toString().replace("\\", "/"));
                try {
                    zs.putNextEntry(zipEntry);
                    Files.copy(path, zs);
                    zs.closeEntry();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
    }
}

