/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.aristois.installer.jsonbuilder.launchers.custom;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Files;
import me.deftware.aristois.installer.InstallerAPI;
import me.deftware.aristois.installer.jsonbuilder.JsonBuilder;
import me.deftware.aristois.installer.jsonbuilder.launchers.vanilla.SubsystemJsonBuilder;
import me.deftware.aristois.installer.jsonbuilder.launchers.vanilla.TweakerJsonBuilder;
import me.deftware.aristois.installer.jsonbuilder.launchers.vanilla.TweakerJsonBuilderLegacy;
import me.deftware.aristois.installer.utils.LauncherType;
import me.deftware.aristois.installer.utils.VersionData;

public class MultiMcJsonBuilder
implements JsonBuilder {
    @Override
    public JsonObject build(VersionData data) {
        JsonObject json = new JsonObject();
        JsonObject requiresData = new JsonObject();
        json.addProperty("name", "Aristois" + (InstallerAPI.isDonorBuild() ? " Donor" : ""));
        json.addProperty("releaseTime", JsonBuilder.getDate(new String[0]));
        JsonArray requiresArray = new JsonArray();
        requiresData.addProperty("equals", data.getVersion());
        requiresData.addProperty("uid", "net.minecraft");
        requiresArray.add(requiresData);
        json.add("requires", requiresArray);
        json.addProperty("uid", "me.deftware");
        json.addProperty("version", data.getEmc().split(":")[1]);
        json.addProperty("formatVersion", 1);
        if (data.getTweaker() != null) {
            json.addProperty("mainClass", data.getMainClass());
            JsonArray tweakerArray = new JsonArray();
            tweakerArray.add(data.getTweaker());
            json.add("+tweakers", tweakerArray);
            String versionData = data.getVersion();
            if (versionData.split("\\.").length == 2) {
                versionData = versionData + ".0";
            }
            if (Integer.parseInt(versionData.replaceAll("\\.", "")) <= 1122) {
                json.add("+libraries", TweakerJsonBuilderLegacy.getLibraries(data));
            } else {
                json.add("+libraries", TweakerJsonBuilder.getLibraries(data));
            }
        } else {
            json.addProperty("mainClass", "me.deftware.weaver.Main");
            json.add("+libraries", SubsystemJsonBuilder.getLibraries(data));
        }
        return json;
    }

    @Override
    public String install(JsonObject json, VersionData data, String rootDir) {
        File parent = new File(rootDir + "patches" + File.separator);
        File jsonFile = new File(parent.getAbsolutePath() + File.separator + "me.deftware.json");
        if (!parent.exists() && !parent.mkdirs()) {
            System.out.printf("Failed to create %s\n", parent.getAbsolutePath());
        }
        if (jsonFile.exists() && !jsonFile.delete()) {
            System.out.printf("Could not delete %s\n", jsonFile.getName());
        }
        try (FileWriter writer = new FileWriter(jsonFile);){
            new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json, (Appendable)writer);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.addLauncherProfile(data, rootDir, null);
        return "Aristois has been installed, restart your MultiMC launcher and select your instance with Aristois and start playing";
    }

    @Override
    public void addLauncherProfile(VersionData data, String rootDir, LauncherType launcherType) {
        JsonObject json = new JsonObject();
        json.addProperty("cachedName", "Aristois " + data.getVersion());
        json.addProperty("cachedVersion", data.getVersion() + "-Aristois");
        json.addProperty("uid", "me.deftware");
        File pack_json = new File(rootDir + "mmc-pack.json");
        try {
            JsonObject packJson = JsonParser.parseReader(Files.newBufferedReader(pack_json.toPath())).getAsJsonObject();
            JsonArray components = packJson.get("components").getAsJsonArray();
            components.add(json);
            try (FileWriter writer = new FileWriter(pack_json);){
                new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)packJson, (Appendable)writer);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

