/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.aristois.installer.jsonbuilder.launchers.vanilla;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.Base64;
import me.deftware.aristois.installer.Main;
import me.deftware.aristois.installer.jsonbuilder.JsonBuilder;
import me.deftware.aristois.installer.utils.LauncherType;
import me.deftware.aristois.installer.utils.Utils;
import me.deftware.aristois.installer.utils.VersionData;
import org.apache.commons.io.IOUtils;

public class SubsystemJsonBuilder
implements JsonBuilder {
    @Override
    public JsonObject build(VersionData data) {
        JsonObject json = new JsonObject();
        json.addProperty("inheritsFrom", data.getVersion());
        json.addProperty("id", data.getVersion() + "-Aristois");
        json.addProperty("time", JsonBuilder.getDate(new String[0]));
        json.addProperty("releaseTime", JsonBuilder.getDate(new String[0]));
        json.addProperty("type", "release");
        json.addProperty("mainClass", "me.deftware.weaver.Main");
        json.add("libraries", SubsystemJsonBuilder.getLibraries(data));
        return json;
    }

    public static JsonArray getLibraries(VersionData data) {
        JsonArray libraries = new JsonArray();
        data.getLibraries().forEach(l -> libraries.add(JsonBuilder.generateMavenRepo(l.getName(), l.getUrl())));
        libraries.add(JsonBuilder.generateMavenRepo("me.deftware:" + data.getEmc(), "https://gitlab.com/EMC-Framework/maven/raw/master/"));
        libraries.add(JsonBuilder.generateMavenRepo("me.deftware:weaver:" + data.getWeaver(), "https://gitlab.com/EMC-Framework/maven/raw/master/"));
        libraries.add(JsonBuilder.generateMavenRepo("net.fabricmc:loader-v2:latest", "https://gitlab.com/EMC-Framework/maven/raw/master/"));
        libraries.add(JsonBuilder.generateMavenRepo("net.fabricmc:sponge-mixin:" + data.getMixin(), "https://maven.fabricmc.net/"));
        libraries.add(JsonBuilder.generateMavenRepo("net.fabricmc:tiny-remapper:0.8.2", "https://maven.fabricmc.net/"));
        libraries.add(JsonBuilder.generateMavenRepo("net.fabricmc:tiny-mappings-parser:0.3.0+build.17", "https://maven.fabricmc.net/"));
        libraries.add(JsonBuilder.generateMavenRepo("net.fabricmc:access-widener:2.1.0", "https://maven.fabricmc.net/"));
        libraries.add(JsonBuilder.generateMavenRepo("org.ow2.asm:asm:" + data.getAsm(), "https://maven.fabricmc.net/"));
        libraries.add(JsonBuilder.generateMavenRepo("org.ow2.asm:asm-analysis:" + data.getAsm(), "https://maven.fabricmc.net/"));
        libraries.add(JsonBuilder.generateMavenRepo("org.ow2.asm:asm-commons:" + data.getAsm(), "https://maven.fabricmc.net/"));
        libraries.add(JsonBuilder.generateMavenRepo("org.ow2.asm:asm-tree:" + data.getAsm(), "https://maven.fabricmc.net/"));
        libraries.add(JsonBuilder.generateMavenRepo("org.ow2.asm:asm-util:" + data.getAsm(), "https://maven.fabricmc.net/"));
        if (data.getProtocolVersion() > 758) {
            libraries.add(JsonBuilder.generateMavenRepo("io.netty:netty-handler-proxy:" + data.getNetty(), "https://repo.maven.apache.org/maven2/"));
        }
        libraries.add(JsonBuilder.generateMavenRepo("net.fabricmc:intermediary:" + data.getVersion(), "https://maven.fabricmc.net/"));
        if (Utils.isMac()) {
            libraries.add(JsonBuilder.generateMavenRepo("com.thizzer.jtouchbar:jtouchbar:1.0.0", "https://repo1.maven.org/maven2/"));
        }
        String alteningName = "com.thealtening.auth:auth:3.0.2";
        if (data.getProtocolVersion() >= 755) {
            alteningName = alteningName + "-j9";
        }
        libraries.add(JsonBuilder.generateMavenRepo(alteningName, "https://repo.maven.apache.org/maven2/"));
        return libraries;
    }

    @Override
    public String install(JsonObject json, VersionData data, String rootDir) {
        File parent = new File(rootDir + "versions" + File.separator + data.getVersion() + "-Aristois" + File.separator);
        File jsonFile = new File(parent.getAbsolutePath() + File.separator + data.getVersion() + "-Aristois.json");
        if (!parent.exists() && !parent.mkdirs()) {
            System.out.printf("Failed to create %s\n", parent.getAbsolutePath());
        }
        if (jsonFile.exists() && !jsonFile.delete()) {
            System.out.printf("Could not delete %s\n", jsonFile.getName());
        }
        try (FileWriter writer = new FileWriter(jsonFile);){
            new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json, (Appendable)writer);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (LauncherType type : LauncherType.values()) {
            File profiles = new File(rootDir + type.getProfiles());
            if (!profiles.exists()) continue;
            this.addLauncherProfile(data, rootDir, type);
        }
        return "Aristois has been installed, restart your Minecraft launcher and select \"release " + data.getVersion() + "-Aristois\" and hit play";
    }

    @Override
    public void addLauncherProfile(VersionData data, String rootDir, LauncherType launcherType) {
        block46: {
            System.out.printf("Creating launcher profile for Aristois %s (%s launcher)\n", data.getVersion(), launcherType.name());
            JsonObject json = new JsonObject();
            json.addProperty("name", "Aristois " + data.getVersion());
            json.addProperty("type", "custom");
            json.addProperty("created", JsonBuilder.getDate("ms"));
            json.addProperty("lastUsed", JsonBuilder.getDate("ms"));
            json.addProperty("lastVersionId", data.getVersion() + "-Aristois");
            try (InputStream logo = Main.class.getResourceAsStream("/logo.png");){
                if (logo != null) {
                    String bImage = Base64.getEncoder().encodeToString(IOUtils.toByteArray(logo));
                    json.addProperty("icon", "data:image/png;base64," + bImage);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            File profiles_json = new File(rootDir + launcherType.getProfiles());
            File launcher_ui_state = new File(rootDir + "launcher_ui_state.json");
            try {
                if (profiles_json.exists()) {
                    JsonObject launcherJson = JsonParser.parseReader(Files.newBufferedReader(profiles_json.toPath())).getAsJsonObject();
                    JsonObject profiles = launcherJson.get("profiles").getAsJsonObject();
                    if (profiles.has("Aristois " + data.getVersion())) {
                        profiles.remove("Aristois " + data.getVersion());
                    }
                    profiles.add("Aristois " + data.getVersion(), json);
                    launcherJson.addProperty("selectedProfile", "Aristois " + data.getVersion());
                    try (FileWriter writer = new FileWriter(profiles_json);){
                        new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)launcherJson, (Appendable)writer);
                    }
                }
                if (!launcher_ui_state.exists()) break block46;
                JsonObject uiJson = JsonParser.parseReader(Files.newBufferedReader(launcher_ui_state.toPath())).getAsJsonObject();
                JsonObject jsonData = uiJson.get("data").getAsJsonObject();
                String uiSettings = jsonData.get("UiSettings").getAsString();
                jsonData.remove("UiSettings");
                if (uiSettings.contains("\"modded\":false")) {
                    uiSettings = uiSettings.replace("\"modded\":false", "\"modded\":true");
                }
                jsonData.addProperty("UiSettings", uiSettings);
                try (FileWriter writer = new FileWriter(launcher_ui_state);){
                    new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)uiJson, (Appendable)writer);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

