/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.aristois.installer.modloader.impl;

import java.io.File;
import me.deftware.aristois.installer.InstallerAPI;
import me.deftware.aristois.installer.modloader.ModLoader;
import me.deftware.aristois.installer.utils.Utils;
import me.deftware.aristois.installer.utils.VersionData;

public class ForgeInstaller
implements ModLoader {
    @Override
    public String install(VersionData data, String rootDir) {
        String versionData = data.getVersion();
        if (versionData.split("\\.").length == 2) {
            versionData = versionData + ".0";
        }
        File modsDir = new File(Integer.parseInt(versionData.replaceAll("\\.", "")) < 1150 ? rootDir + "mods" + File.separator + data.getVersion() + File.separator : rootDir + "mods" + File.separator);
        File emc = new File(modsDir.getAbsolutePath() + File.separator + "EMC.jar");
        if (!modsDir.exists() && !modsDir.mkdirs()) {
            System.out.printf("Could not create %s\n", modsDir.getAbsolutePath());
        }
        File emcDir = new File(rootDir + "libraries" + File.separator + "EMC" + File.separator + data.getVersion() + File.separator);
        File aristois = new File(emcDir.getAbsolutePath() + File.separator + "Aristois.jar");
        if (!emcDir.exists() && !emcDir.mkdirs()) {
            System.out.printf("Could not create %s\n", emcDir.getAbsolutePath());
        }
        try {
            Utils.download(Utils.getMavenUrl(String.format("me.deftware:%s-Forge:%s", data.getEmc().split(":")[0].replace("-F-v2", ""), data.getEmc().split(":")[1]), "https://gitlab.com/EMC-Framework/maven/raw/master/"), emc);
            if (!data.getModLoaderDependencies().isEmpty()) {
                for (String dep : data.getModLoaderDependencies()) {
                    File dependency = new File(modsDir.getAbsolutePath() + File.separator + dep.split("/")[dep.split("/").length - 1]);
                    Utils.download(dep, dependency);
                }
            }
            Utils.download(Utils.getMavenUrl(String.format("me.deftware:aristois%s:latest-%s", InstallerAPI.isDonorBuild() ? "-d" : "", data.getVersion()), "https://maven.aristois.net/"), aristois);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return "Aristois for Forge has been installed, start your Forge instance and play";
    }
}

