/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.aristois.installer.ui;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import me.deftware.aristois.installer.InstallerAPI;
import me.deftware.aristois.installer.jsonbuilder.JsonBuilder;
import me.deftware.aristois.installer.modloader.impl.ForgeInstaller;
import me.deftware.aristois.installer.ui.DialogUI;
import me.deftware.aristois.installer.ui.PathSelectionUI;
import me.deftware.aristois.installer.utils.Utils;
import me.deftware.aristois.installer.utils.VersionData;

public class InstallerUI {
    private JButton installButton;
    private JButton cancelButton;
    private JComboBox<String> mcVersionComboBox;
    private JPanel mainPanel;
    private JLabel madeByLabel;
    private JComboBox<String> launcherComboBox;
    private JComboBox<String> modLoaderComboBox;

    public InstallerUI(JFrame frame) {
        this.$$$setupUI$$$();
        this.madeByLabel.setText(this.madeByLabel.getText());
        frame.setTitle(String.format("Aristois %sInstaller", InstallerAPI.isDonorBuild() ? "Donor Version " : ""));
        this.installButton.addActionListener(e -> this.install());
        this.cancelButton.addActionListener(e -> System.exit(0));
        ArrayList<String> versions = new ArrayList<String>();
        InstallerAPI.getVersions().keySet().forEach(k -> {
            if (k.split("\\.").length == 2) {
                k = k + ".0";
            }
            versions.add((String)k);
        });
        versions.sort(Comparator.comparingInt(value -> Integer.parseInt(value.replaceAll("\\.", ""))));
        Collections.reverse(versions);
        versions.forEach(v -> this.mcVersionComboBox.addItem(v.replace(".0", "")));
        this.mcVersionComboBox.addActionListener(e -> this.updateComboBoxes());
        this.updateComboBoxes();
    }

    private void updateComboBoxes() {
        if (this.mcVersionComboBox.getSelectedItem() != null) {
            VersionData data = InstallerAPI.getVersions().get(this.mcVersionComboBox.getSelectedItem().toString());
            this.launcherComboBox.removeAllItems();
            data.getLaunchers().forEach(this.launcherComboBox::addItem);
            this.modLoaderComboBox.removeAllItems();
            this.modLoaderComboBox.addItem("None");
            data.getModLoaders().forEach(this.modLoaderComboBox::addItem);
        }
    }

    private void install() {
        VersionData data = InstallerAPI.getVersions().get(Objects.requireNonNull(this.mcVersionComboBox.getSelectedItem()).toString());
        String launcher = Objects.requireNonNull(this.launcherComboBox.getSelectedItem()).toString();
        String modLoader = Objects.requireNonNull(this.modLoaderComboBox.getSelectedItem()).toString();
        PathSelectionUI pathSelector = new PathSelectionUI(launcher.equalsIgnoreCase("multimc") ? "Please enter your MultiMC instance you want to add Aristois to:" : "Please enter your .minecraft directory:", Utils.getMinecraftRoot(), p -> new Thread(() -> {
            Thread.currentThread().setName("Install thread");
            DialogUI installingDialog = new DialogUI("Aristois is being installed... Please wait...", "Installing...", false, () -> {});
            installingDialog.setAlwaysOnTop(true);
            new Thread(() -> installingDialog.setVisible(true)).start();
            String result = "";
            if (modLoader.equalsIgnoreCase("forge")) {
                result = new ForgeInstaller().install(data, (String)p);
            } else {
                JsonBuilder builder = data.getBuilder(modLoader, launcher);
                result = builder.install(builder.build(data), data, (String)p);
            }
            DialogUI dialog = new DialogUI(result, "Install complete", true, () -> System.exit(0));
            installingDialog.dispose();
            dialog.setAlwaysOnTop(true);
            dialog.setVisible(true);
        }).start());
        pathSelector.setAlwaysOnTop(true);
        pathSelector.setVisible(true);
    }

    public static JFrame create() {
        JFrame frame = new JFrame("");
        InstallerUI ui = new InstallerUI(frame);
        JPanel panel = ui.mainPanel;
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        frame.setContentPane(panel);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation(dim.width / 2 - frame.getSize().width / 2, dim.height / 2 - frame.getSize().height / 2);
        return frame;
    }

    private void $$$setupUI$$$() {
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1));
        this.installButton = new JButton();
        this.installButton.setEnabled(true);
        this.installButton.setText("Install");
        this.mainPanel.add((Component)this.installButton, new GridConstraints(4, 1, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.cancelButton = new JButton();
        this.cancelButton.setEnabled(true);
        this.cancelButton.setText("Cancel");
        this.mainPanel.add((Component)this.cancelButton, new GridConstraints(4, 0, 1, 1, 0, 1, 3, 0, null, null, null, 0, false));
        this.mcVersionComboBox = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel1 = new DefaultComboBoxModel();
        this.mcVersionComboBox.setModel(defaultComboBoxModel1);
        this.mainPanel.add(this.mcVersionComboBox, new GridConstraints(1, 0, 1, 2, 8, 1, 2, 0, null, null, null, 0, false));
        JLabel label1 = new JLabel();
        label1.setText("Select Launcher and ModLoader to Install to:");
        this.mainPanel.add((Component)label1, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null, 0, false));
        JLabel label2 = new JLabel();
        label2.setText("Select which Minecraft version you want to install for:");
        this.mainPanel.add((Component)label2, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null, 0, false));
        this.launcherComboBox = new JComboBox();
        DefaultComboBoxModel defaultComboBoxModel2 = new DefaultComboBoxModel();
        this.launcherComboBox.setModel(defaultComboBoxModel2);
        this.mainPanel.add(this.launcherComboBox, new GridConstraints(3, 0, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        this.modLoaderComboBox = new JComboBox();
        this.modLoaderComboBox.setEnabled(true);
        this.mainPanel.add(this.modLoaderComboBox, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null, 0, false));
        this.madeByLabel = new JLabel();
        this.madeByLabel.setText("Made by https://deftware.me/");
        this.mainPanel.add((Component)this.madeByLabel, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(287, 16), null, 0, false));
    }

    public JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }
}

