/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.aristois.installer.utils;

import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.deftware.aristois.installer.InstallerAPI;
import me.deftware.aristois.installer.jsonbuilder.JsonBuilder;
import me.deftware.aristois.installer.jsonbuilder.launchers.custom.MultiMcJsonBuilder;
import me.deftware.aristois.installer.jsonbuilder.launchers.vanilla.SubsystemJsonBuilder;
import me.deftware.aristois.installer.jsonbuilder.launchers.vanilla.TweakerJsonBuilder;
import me.deftware.aristois.installer.jsonbuilder.launchers.vanilla.TweakerJsonBuilderLegacy;

public class VersionData {
    @SerializedName(value="beta")
    private boolean beta = false;
    @SerializedName(value="version")
    private String version;
    @SerializedName(value="mixin")
    private String mixin = "0.11.4+mixin.0.8.5";
    @SerializedName(value="weaver")
    private String weaver = "1.0.0";
    @SerializedName(value="asm")
    private String asm = "9.3";
    @SerializedName(value="netty")
    private String netty = "4.1.76.Final";
    @SerializedName(value="protocolVersion")
    private int protocolVersion;
    @SerializedName(value="emc")
    private String emc;
    @SerializedName(value="tweaker")
    private String tweaker;
    @SerializedName(value="mainClass")
    private String mainClass = "me.deftware.client.framework.main.Main";
    @SerializedName(value="launchers")
    private List<String> launchers = Arrays.asList("Vanilla", "MultiMC");
    @SerializedName(value="modLoaders")
    private List<String> modLoaders = new ArrayList<String>();
    @SerializedName(value="modLoaderDependencies")
    private List<String> modLoaderDependencies = new ArrayList<String>();
    @SerializedName(value="libraries")
    private List<VersionLibrary> libraries = Collections.singletonList(new VersionLibrary(String.format("me.deftware:aristois%s:loader%s", InstallerAPI.isDonorBuild() ? "-d" : "", InstallerAPI.isUniversal() ? "-universal" : ""), "https://maven.aristois.net/"));

    public JsonBuilder getBuilder(String modLoader, String launcher) {
        if (launcher.equalsIgnoreCase("multimc")) {
            return new MultiMcJsonBuilder();
        }
        if (this.tweaker != null) {
            String versionData = this.version;
            if (versionData.split("\\.").length == 2) {
                versionData = versionData + ".0";
            }
            if (Integer.parseInt(versionData.replaceAll("\\.", "")) <= 1122) {
                return new TweakerJsonBuilderLegacy();
            }
            return new TweakerJsonBuilder();
        }
        return new SubsystemJsonBuilder();
    }

    public boolean isBeta() {
        return this.beta;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMixin() {
        return this.mixin;
    }

    public String getWeaver() {
        return this.weaver;
    }

    public String getAsm() {
        return this.asm;
    }

    public String getNetty() {
        return this.netty;
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getEmc() {
        return this.emc;
    }

    public String getTweaker() {
        return this.tweaker;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public List<String> getLaunchers() {
        return this.launchers;
    }

    public List<String> getModLoaders() {
        return this.modLoaders;
    }

    public List<String> getModLoaderDependencies() {
        return this.modLoaderDependencies;
    }

    public List<VersionLibrary> getLibraries() {
        return this.libraries;
    }

    public static class VersionLibrary {
        @SerializedName(value="name")
        private String name;
        @SerializedName(value="url")
        private String url;

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public VersionLibrary(String name, String url) {
            this.name = name;
            this.url = url;
        }
    }
}

