/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.installer;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.Nonnull;
import me.deftware.installer.OSUtils;

public class LocationUtil {
    private URL url;
    private File file;

    private LocationUtil(URL url) {
        this.url = url;
    }

    private LocationUtil(File file) {
        this.file = file;
    }

    public static LocationUtil getClassPhysicalLocation(@Nonnull Class<?> c) {
        String suffix;
        try {
            URL codeSourceLocation = c.getProtectionDomain().getCodeSource().getLocation();
            if (codeSourceLocation != null) {
                return new LocationUtil(codeSourceLocation);
            }
        }
        catch (NullPointerException | SecurityException codeSourceLocation) {
            // empty catch block
        }
        URL classResource = c.getResource(c.getSimpleName() + ".class");
        if (classResource == null) {
            return new LocationUtil((URL)null);
        }
        String url = classResource.toString();
        if (!url.endsWith(suffix = c.getCanonicalName().replace('.', '/') + ".class")) {
            return new LocationUtil((URL)null);
        }
        String base = url.substring(0, url.length() - suffix.length());
        String path = base;
        if (path.startsWith("jar:")) {
            path = path.substring(4, path.length() - 2);
        }
        try {
            return new LocationUtil(new URL(path));
        }
        catch (MalformedURLException e) {
            return new LocationUtil((URL)null);
        }
    }

    public File toFile() {
        block6: {
            if (this.file != null) {
                return this.file;
            }
            if (this.url != null) {
                String path = this.url.toString();
                if (path.startsWith("jar:")) {
                    path = path.substring(4, path.indexOf("!/"));
                }
                try {
                    if (OSUtils.isWindows() && path.matches("file:[A-Za-z]:.*")) {
                        path = "file:/" + path.substring(5);
                    }
                    return new File(new URL(path).toURI());
                }
                catch (MalformedURLException | URISyntaxException exception) {
                    if (!path.startsWith("file:")) break block6;
                    return new File(path.substring(5));
                }
            }
        }
        return null;
    }
}

