/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.installer;

import javax.swing.UIManager;
import me.deftware.aristois.installer.InstallerAPI;
import me.deftware.installer.LocationUtil;
import me.deftware.installer.OSUtils;
import me.deftware.installer.engine.MainWindow;
import me.deftware.installer.engine.NativeManager;
import me.deftware.installer.resources.font.FontManager;

public class Main {
    private static final String donorString = "false";
    public static String version = "2.0.3";
    public static MainWindow window;

    public static void main(String[] args) {
        if (args.length != 0 && !OSUtils.isMac()) {
            System.setProperty("org.lwjgl.util.Debug", "true");
            try {
                NativeManager.loadNatives();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        System.out.println("Running Java " + System.getProperty("java.version"));
        System.out.println("OS arch " + System.getProperty("os.arch"));
        System.out.println("Installer version " + version);
        System.out.println("Donor build false");
        InstallerAPI.setDonorBuild(Boolean.parseBoolean(donorString));
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            FontManager.loadFontFromAssets("/assets/NotoSans-Regular.ttf");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (OSUtils.isMac()) {
            MainWindow.openLegacy();
        } else {
            try {
                window = new MainWindow();
                window.run();
            }
            catch (UnsatisfiedLinkError ex) {
                System.err.println("Unsatisfied lwjgl link error, trying to fix it...");
                if (args.length == 0) {
                    NativeManager.extractNatives();
                    System.out.println("Restarting app...");
                    Main.restart();
                } else {
                    System.out.println("Failed to load native libraries, defaulting to legacy mode...");
                    MainWindow.openLegacy();
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                MainWindow.openLegacy();
            }
        }
    }

    public static void restart() {
        try {
            LocationUtil self = LocationUtil.getClassPhysicalLocation(Main.class);
            if (self.toFile() == null || !self.toFile().exists()) {
                throw new Exception("Could not find self");
            }
            Runtime.getRuntime().exec("java -jar " + self.toFile().getAbsolutePath() + " --loadNatives");
            System.exit(0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            MainWindow.openLegacy();
        }
    }

    public static String getVersion() {
        return version;
    }

    public static MainWindow getWindow() {
        return window;
    }
}

