/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.installer;

import java.io.File;
import javax.annotation.Nullable;

public class OSUtils {
    private static String OS = System.getProperty("os.name").toLowerCase();

    public static boolean isWindows() {
        return OS.contains("win");
    }

    public static boolean isMac() {
        return OS.contains("darwin") || OS.contains("mac");
    }

    public static boolean isLinux() {
        return OS.contains("nux");
    }

    @Nullable
    public static String getMCDir() {
        if (OSUtils.isWindows()) {
            return System.getenv("APPDATA") + File.separator + ".minecraft" + File.separator;
        }
        if (OSUtils.isLinux()) {
            return System.getProperty("user.home") + File.separator + ".minecraft" + File.separator;
        }
        if (OSUtils.isMac()) {
            return System.getProperty("user.home") + File.separator + "Library" + File.separator + "Application Support" + File.separator + "minecraft" + File.separator;
        }
        return null;
    }
}

