/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.installer.engine;

import de.matthiasmann.twl.utils.PNGDecoder;
import java.awt.Color;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import me.deftware.aristois.installer.InstallerAPI;
import me.deftware.aristois.installer.ui.InstallerUI;
import me.deftware.installer.Main;
import me.deftware.installer.OSUtils;
import me.deftware.installer.engine.WindowDecorations;
import me.deftware.installer.engine.theming.ThemeEngine;
import me.deftware.installer.resources.RenderSystem;
import me.deftware.installer.resources.font.BitmapFont;
import me.deftware.installer.resources.font.FontManager;
import me.deftware.installer.screen.AbstractScreen;
import me.deftware.installer.screen.impl.WelcomeScreen;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.Callbacks;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWImage;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.system.MemoryStack;

public class MainWindow
implements Runnable {
    public long windowHandle;
    public double mouseX;
    public double mouseY;
    public static boolean borderlessWindow = true;
    public static boolean legacyOpen = false;
    public int windowWidth = 800;
    public int windowHeight = 500;
    private boolean transitionForward = true;
    private double iterations = 50.0;
    private double i = 0.0;
    private double counter = 0.0;
    private double increase = Math.PI / this.iterations;
    private DoubleBuffer posX = BufferUtils.createDoubleBuffer(1);
    private DoubleBuffer posY = BufferUtils.createDoubleBuffer(1);
    public AbstractScreen currentScreen;
    public AbstractScreen transitionScreen;
    public AbstractScreen previousScreen;
    private WindowDecorations windowDecorations;
    private List<Runnable> renderThreadRunner = new ArrayList<Runnable>();
    private boolean scheduleRefresh = false;
    private static HashMap<Integer, Long> cursorCache = new HashMap();
    public boolean shouldRun = true;

    @Override
    public void run() {
        if (OSUtils.isLinux()) {
            borderlessWindow = false;
        }
        ScheduledFuture<?> updatedThread = Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> {
            if (this.currentScreen != null) {
                this.currentScreen.update();
            }
            if (this.transitionScreen != null) {
                this.handleTransition();
            }
        }, 0L, 16L, TimeUnit.MILLISECONDS);
        this.init();
        this.loop();
        updatedThread.cancel(true);
        Callbacks.glfwFreeCallbacks(this.windowHandle);
        GLFW.glfwDestroyWindow(this.windowHandle);
        GLFW.glfwTerminate();
        Objects.requireNonNull(GLFW.glfwSetErrorCallback(null)).free();
        if (!legacyOpen) {
            System.exit(0);
        }
    }

    private void handleTransition() {
        if (this.transitionScreen.getX() > 0 && this.transitionForward || this.transitionScreen.getX() < 0 && !this.transitionForward) {
            if (this.i <= 1.0) {
                double transition = Math.sin(this.counter) * ((double)this.windowWidth / this.iterations * this.counter);
                if (this.transitionForward) {
                    this.transitionScreen.setX((int)((double)this.transitionScreen.getX() - transition));
                } else {
                    this.transitionScreen.setX((int)((double)this.transitionScreen.getX() + transition));
                }
                this.counter += this.increase;
                this.i += 1.0 / this.iterations;
            }
            if (this.transitionForward) {
                this.currentScreen.setX(this.transitionScreen.getX() - this.windowWidth);
            } else {
                this.currentScreen.setX(this.transitionScreen.getX() + this.windowWidth);
            }
        } else {
            this.currentScreen = this.transitionScreen;
            this.currentScreen.setX(0);
            this.transitionScreen = null;
        }
    }

    public void transitionForward(AbstractScreen screen) {
        this.previousScreen = this.currentScreen;
        this.renderThreadRunner.add(() -> {
            screen.initSuper();
            this.transitionForward = true;
            this.counter = 0.0;
            this.i = 0.0;
            screen.setX(this.windowWidth);
            this.transitionScreen = screen;
        });
    }

    public void transitionBackwards(AbstractScreen screen) {
        this.previousScreen = this.currentScreen;
        this.renderThreadRunner.add(() -> {
            screen.initSuper();
            this.transitionForward = false;
            this.counter = 0.0;
            this.i = 0.0;
            screen.setX(-this.windowWidth);
            this.transitionScreen = screen;
        });
    }

    public boolean isTransitioning() {
        return this.transitionScreen != null;
    }

    public static void openLegacy() {
        if (!legacyOpen) {
            System.out.println("Opening in legacy mode");
            legacyOpen = true;
            InstallerAPI.fetchData(false);
            InstallerUI.create().setVisible(true);
        }
    }

    private void init() {
        GLFWErrorCallback.createPrint(System.err).set();
        if (!GLFW.glfwInit()) {
            System.err.println("Failed to init glfw");
            MainWindow.openLegacy();
            return;
        }
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint(131076, 0);
        GLFW.glfwWindowHint(131075, 0);
        if (borderlessWindow) {
            GLFW.glfwWindowHint(131077, 0);
        }
        this.windowHandle = GLFW.glfwCreateWindow(this.windowWidth, this.windowHeight, InstallerAPI.isDonorBuild() ? "Donor edition" : "", 0L, 0L);
        if (this.windowHandle == 0L) {
            System.err.println("NULL window handle");
            MainWindow.openLegacy();
            return;
        }
        try {
            PNGDecoder decoder = new PNGDecoder(Main.class.getResourceAsStream("/assets/logo.png"));
            ByteBuffer buf = BufferUtils.createByteBuffer(decoder.getWidth() * decoder.getHeight() * 4);
            decoder.decode(buf, decoder.getWidth() * 4, PNGDecoder.Format.RGBA);
            buf.flip();
            GLFWImage image = GLFWImage.malloc();
            image.set(decoder.getWidth(), decoder.getHeight(), buf);
            GLFWImage.Buffer images = GLFWImage.malloc(1);
            GLFW.glfwSetWindowIcon(this.windowHandle, (GLFWImage.Buffer)images.put(0, image));
            images.free();
            image.free();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        GLFW.glfwSetKeyCallback(this.windowHandle, (window, key, scancode, action, mods) -> {
            if (this.currentScreen != null && action != 0 && this.shouldRun) {
                this.currentScreen.keyPressed(key, mods);
            }
        });
        GLFW.glfwSetCharCallback(this.windowHandle, (window, codepoint) -> {
            if (this.currentScreen != null && this.shouldRun) {
                this.currentScreen.charTyped((char)codepoint);
            }
        });
        GLFW.glfwSetWindowCloseCallback(this.windowHandle, window -> GLFW.glfwSetWindowShouldClose(this.windowHandle, true));
        GLFW.glfwSetScrollCallback(this.windowHandle, (window, xPos, yPos) -> {
            if (this.currentScreen != null && this.shouldRun) {
                this.currentScreen.onScroll(xPos, yPos);
            }
        });
        if (!borderlessWindow) {
            GLFW.glfwSetMouseButtonCallback(this.windowHandle, (window, button, action, mods) -> this.mousePressed(button, action));
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer pWidth = stack.mallocInt(1);
            IntBuffer pHeight = stack.mallocInt(1);
            GLFW.glfwGetWindowSize(this.windowHandle, pWidth, pHeight);
            GLFWVidMode vidmode = GLFW.glfwGetVideoMode(GLFW.glfwGetPrimaryMonitor());
            GLFW.glfwSetWindowPos(this.windowHandle, (vidmode.width() - pWidth.get(0)) / 2, (vidmode.height() - pHeight.get(0)) / 2);
        }
        GLFW.glfwMakeContextCurrent(this.windowHandle);
        GLFW.glfwSwapInterval(1);
        GLFW.glfwShowWindow(this.windowHandle);
    }

    public void mousePressed(int button, int action) {
        if (this.currentScreen != null && !this.isTransitioning() && this.shouldRun) {
            if (action == 1) {
                this.currentScreen.mouseClicked(this.mouseX, this.mouseY, button);
            } else if (action == 0) {
                this.currentScreen.mouseReleased(this.mouseX, this.mouseY, button);
            }
        }
    }

    public void close() {
        GLFW.glfwSetWindowShouldClose(Main.getWindow().getWindowHandle(), true);
    }

    private void setupView() {
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, this.windowWidth, this.windowHeight, 0.0, -1.0, 1.0);
        GL11.glMatrixMode(5888);
    }

    private void loop() {
        GL.createCapabilities();
        this.setupView();
        BitmapFont font = FontManager.getFont("NotoSans-Regular", 18, FontManager.Modifiers.ANTIALIASED);
        font.setShadowSize(1);
        font.initialize(Color.white, "");
        if (borderlessWindow) {
            this.windowDecorations = new WindowDecorations(InstallerAPI.isDonorBuild() ? "Donor edition" : "");
        }
        this.currentScreen = new WelcomeScreen();
        this.currentScreen.initSuper();
        while (!GLFW.glfwWindowShouldClose(this.windowHandle)) {
            RenderSystem.glClearColor(ThemeEngine.getTheme().getBackgroundColor());
            GL11.glClear(16640);
            GLFW.glfwGetCursorPos(this.windowHandle, this.posX, this.posY);
            this.mouseX = this.posX.get();
            this.mouseY = this.posY.get();
            this.posX.clear();
            this.posY.clear();
            GL11.glEnable(3553);
            if (!this.renderThreadRunner.isEmpty()) {
                for (Runnable runnable : this.renderThreadRunner) {
                    runnable.run();
                }
                this.renderThreadRunner.clear();
            }
            if (this.currentScreen != null) {
                if (this.scheduleRefresh) {
                    this.scheduleRefresh = false;
                    this.currentScreen.setInitialized(false);
                    this.currentScreen.initSuper();
                }
                this.currentScreen.render(this.mouseX, this.mouseY);
            }
            if (this.transitionScreen != null) {
                this.transitionScreen.render(this.mouseX, this.mouseY);
            }
            font.drawString(4, this.windowHeight - font.getStringHeight("ABC") - 2, "aristois.net");
            if (borderlessWindow) {
                this.windowDecorations.loop();
            }
            GL11.glDisable(3553);
            GLFW.glfwSwapBuffers(this.windowHandle);
            GLFW.glfwPollEvents();
        }
    }

    public long getWindowHandle() {
        return this.windowHandle;
    }

    public double getMouseX() {
        return this.mouseX;
    }

    public double getMouseY() {
        return this.mouseY;
    }

    public static boolean isBorderlessWindow() {
        return borderlessWindow;
    }

    public static boolean isLegacyOpen() {
        return legacyOpen;
    }

    public WindowDecorations getWindowDecorations() {
        return this.windowDecorations;
    }

    public void setScheduleRefresh(boolean scheduleRefresh) {
        this.scheduleRefresh = scheduleRefresh;
    }

    public static HashMap<Integer, Long> getCursorCache() {
        return cursorCache;
    }
}

