/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.installer.engine;

import java.awt.Color;
import java.nio.IntBuffer;
import me.deftware.installer.Main;
import me.deftware.installer.engine.theming.ThemeEngine;
import me.deftware.installer.resources.RenderSystem;
import me.deftware.installer.resources.font.BitmapFont;
import me.deftware.installer.resources.font.FontManager;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;

public class WindowDecorations {
    private BitmapFont font;
    private final IntBuffer xPos = BufferUtils.createIntBuffer(1);
    private final IntBuffer yPos = BufferUtils.createIntBuffer(1);
    private double cursorPosX;
    private double cursorPosY;
    private double cursorPosXOffset;
    private double cursorPosYOffset;
    private int windowPosX;
    private int windowPosY;
    private int buttonEvent;
    private int titleBarHeight = 40;
    private int navButtonsSize = 20;
    private String windowTitle;
    private boolean centeredTitle = false;
    private boolean dragging = false;
    private int offset = 10;

    public WindowDecorations(String title) {
        this.windowTitle = title;
        GLFW.glfwSetCursorPosCallback(Main.getWindow().getWindowHandle(), (window, x, y) -> {
            if (this.dragging) {
                this.cursorPosXOffset = x - this.cursorPosX;
                this.cursorPosYOffset = y - this.cursorPosY;
            }
        });
        GLFW.glfwSetMouseButtonCallback(Main.getWindow().getWindowHandle(), (window, button, action, mods) -> {
            Main.getWindow().mousePressed(button, action);
            if (button == 0) {
                if (action == 1 && Main.getWindow().mouseY < (double)this.titleBarHeight) {
                    if (Main.getWindow().mouseX > (double)(Main.getWindow().windowWidth - this.offset - this.navButtonsSize) && Main.getWindow().mouseX < (double)(Main.getWindow().windowWidth - this.offset) && Main.getWindow().mouseY > (double)this.offset && Main.getWindow().mouseY < (double)(this.offset + this.navButtonsSize)) {
                        GLFW.glfwSetWindowShouldClose(Main.getWindow().getWindowHandle(), true);
                    } else {
                        this.dragging = true;
                    }
                } else {
                    this.dragging = false;
                }
                this.cursorPosX = Math.floor(Main.getWindow().getMouseX());
                this.cursorPosY = Math.floor(Main.getWindow().getMouseY());
            }
        });
        this.font = FontManager.getFont("NotoSans-Regular", 20, FontManager.Modifiers.ANTIALIASED);
        this.font.initialize(Color.white, "");
    }

    public void loop() {
        if (this.dragging) {
            GLFW.glfwGetWindowPos(Main.getWindow().getWindowHandle(), this.xPos, this.yPos);
            this.windowPosX = this.xPos.get();
            this.windowPosY = this.yPos.get();
            GLFW.glfwSetWindowPos(Main.getWindow().getWindowHandle(), (int)((double)this.windowPosX + this.cursorPosXOffset), (int)((double)this.windowPosY + this.cursorPosYOffset));
            this.yPos.clear();
            this.xPos.clear();
        }
        this.font.drawStringWithShadow(this.centeredTitle ? Main.getWindow().windowWidth / 2 - this.font.getStringWidth(this.windowTitle) / 2 : this.titleBarHeight / 2 - this.font.getStringHeight(this.windowTitle) / 2, this.titleBarHeight / 2 - this.font.getStringHeight(this.windowTitle) / 2, this.windowTitle);
        RenderSystem.drawLine(Main.getWindow().windowWidth - this.navButtonsSize - this.offset, this.offset, Main.getWindow().windowWidth - this.offset, this.offset + this.navButtonsSize, ThemeEngine.getTheme().getOutlineColor());
        RenderSystem.drawLine(Main.getWindow().windowWidth - this.navButtonsSize - this.offset, this.offset + this.navButtonsSize, Main.getWindow().windowWidth - this.offset, this.offset, ThemeEngine.getTheme().getOutlineColor());
    }
}

