/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.installer.resources;

import org.lwjgl.opengl.GL11;

public class Texture {
    private int id;
    private float width;
    private float height;
    private float scale;

    public void draw(float x, float y) throws Exception {
        this.draw(x, y, 1.0f);
    }

    public void draw(float x, float y, float textureScale) throws Exception {
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        GL11.glPushMatrix();
        GL11.glTranslatef(x, y, 0.0f);
        GL11.glBindTexture(3553, this.getId());
        GL11.glBegin(7);
        GL11.glTexCoord2f(0.0f, 0.0f);
        GL11.glVertex2f(0.0f, 0.0f);
        GL11.glTexCoord2f(1.0f, 0.0f);
        GL11.glVertex2f(this.getWidth() / textureScale, 0.0f);
        GL11.glTexCoord2f(1.0f, 1.0f);
        GL11.glVertex2f(this.getWidth() / textureScale, this.getHeight() / textureScale);
        GL11.glTexCoord2f(0.0f, 1.0f);
        GL11.glVertex2f(0.0f, this.getHeight() / textureScale);
        GL11.glEnd();
        GL11.glPopMatrix();
    }

    public int getId() {
        return this.id;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float getScale() {
        return this.scale;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setWidth(float width) {
        this.width = width;
    }

    public void setHeight(float height) {
        this.height = height;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Texture)) {
            return false;
        }
        Texture other = (Texture)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (Float.compare(this.getWidth(), other.getWidth()) != 0) {
            return false;
        }
        if (Float.compare(this.getHeight(), other.getHeight()) != 0) {
            return false;
        }
        return Float.compare(this.getScale(), other.getScale()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof Texture;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        result = result * 59 + Float.floatToIntBits(this.getWidth());
        result = result * 59 + Float.floatToIntBits(this.getHeight());
        result = result * 59 + Float.floatToIntBits(this.getScale());
        return result;
    }

    public String toString() {
        return "Texture(id=" + this.getId() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", scale=" + this.getScale() + ")";
    }

    public Texture(int id, float width, float height, float scale) {
        this.id = id;
        this.width = width;
        this.height = height;
        this.scale = scale;
    }
}

