/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.installer.resources.font;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import me.deftware.installer.engine.theming.ThemeEngine;
import me.deftware.installer.resources.RenderSystem;
import me.deftware.installer.resources.font.FontManager;
import me.deftware.installer.resources.font.GraphicsUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.opengl.GL11;

public class BitmapFont {
    protected int lastRenderedWidth;
    protected int lastRenderedHeight;
    protected String fontName;
    protected int fontSize;
    protected int shadowSize = 1;
    protected boolean antialiased;
    protected boolean memorysaving;
    protected Font stdFont;
    protected HashMap<Character, Integer> textureIDStore = new HashMap();
    protected HashMap<Character, int[]> textureDimensionsStore = new HashMap();

    public BitmapFont(String fontName, int fontSize, int modifiers) {
        this.fontName = fontName;
        this.fontSize = fontSize;
        this.antialiased = (modifiers & 0x20) != 0;
        this.memorysaving = (modifiers & 0x40) != 0;
        this.prepareStandardFont();
        this.lastRenderedWidth = 0;
        this.lastRenderedHeight = 0;
    }

    protected void prepareStandardFont() {
        this.stdFont = FontManager.customFonts.containsKey(this.fontName) ? FontManager.customFonts.get(this.fontName).deriveFont(0, this.fontSize) : new Font(this.fontName, 0, this.fontSize);
    }

    public int initialize(Color color, String extras) {
        if (extras == null) {
            extras = "";
        }
        char[] additionalCharacters = extras.toCharArray();
        for (char lowercaseAlphabet = 'a'; lowercaseAlphabet <= 'z'; lowercaseAlphabet = (char)(lowercaseAlphabet + '\u0001')) {
            this.characterGenerate(lowercaseAlphabet, color);
        }
        for (char uppercaseAlphabet = 'A'; uppercaseAlphabet <= 'Z'; uppercaseAlphabet = (char)(uppercaseAlphabet + '\u0001')) {
            this.characterGenerate(uppercaseAlphabet, color);
        }
        for (char numeric = '0'; numeric <= '9'; numeric = (char)(numeric + '\u0001')) {
            this.characterGenerate(numeric, color);
        }
        char[] specialCharacters = new char[]{'!', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', ':', ';', '<', '=', '>', '?', '@', '[', '\\', ']', '^', '_', '`', '{', '|', '}', '~', '\"'};
        if (additionalCharacters.length > 0) {
            specialCharacters = ArrayUtils.addAll(specialCharacters, additionalCharacters);
        }
        for (char specialCharacter : specialCharacters) {
            this.characterGenerate(specialCharacter, color);
        }
        return 0;
    }

    protected void characterGenerate(char character, Color color) {
        String letterBuffer = String.valueOf(character);
        int textwidth = this.getStringWidth(letterBuffer);
        int textheight = this.getStringHeight(letterBuffer);
        BufferedImage characterTexture = new BufferedImage(textwidth, textheight, 2);
        Graphics2D graphics = characterTexture.createGraphics();
        graphics.setFont(this.stdFont);
        graphics.setColor(color);
        if (this.antialiased) {
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        }
        graphics.drawString(letterBuffer, 0, textheight - textheight / 4);
        graphics.dispose();
        this.textureIDStore.put(Character.valueOf(character), GraphicsUtil.loadTextureFromBufferedImage(characterTexture));
        this.textureDimensionsStore.put(Character.valueOf(character), new int[]{characterTexture.getWidth(), characterTexture.getHeight()});
    }

    public int drawString(int x, int y, String text) {
        return this.drawString(x, y, text, ThemeEngine.getTheme().getTextColor(), ThemeEngine.getTheme().isTextShadow());
    }

    public int drawStringWithShadow(int x, int y, String text) {
        return this.drawString(x, y, text, ThemeEngine.getTheme().getTextColor(), true);
    }

    public int drawString(int x, int y, String text, Color color, boolean shadow) {
        if (shadow) {
            this.drawString(x + this.shadowSize, y + this.shadowSize, text, Color.black);
        }
        this.drawString(x, y, text, color);
        return 0;
    }

    public int drawStringWithShadow(int x, int y, String text, Color color) {
        return this.drawString(x, y, text, color, true);
    }

    public int drawString(int x, int y, String text, Color color) {
        char[] buffer = text.toCharArray();
        GL11.glPushMatrix();
        GL11.glEnable(3042);
        GL11.glBlendFunc(770, 771);
        int offset = 0;
        for (int character = 0; character < buffer.length; ++character) {
            if (buffer[character] == ' ') {
                offset += this.getStringWidth(" ");
                continue;
            }
            if (!this.textureIDStore.containsKey(Character.valueOf(buffer[character]))) {
                buffer[character] = 63;
            }
            if (color != null) {
                float red = color.getRed() > 0 ? (float)color.getRed() * 0.003921569f : 0.0f;
                float green = color.getGreen() > 0 ? (float)color.getGreen() * 0.003921569f : 0.0f;
                float blue = color.getBlue() > 0 ? (float)color.getBlue() * 0.003921569f : 0.0f;
                float alpha = color.getAlpha() > 0 ? (float)color.getAlpha() * 0.003921569f : 0.0f;
                GL11.glColor4f(red, green, blue, alpha);
            }
            GL11.glBindTexture(3553, this.textureIDStore.get(Character.valueOf(buffer[character])));
            GL11.glBlendFunc(770, 771);
            int width = this.textureDimensionsStore.get(Character.valueOf(buffer[character]))[0];
            int height = this.textureDimensionsStore.get(Character.valueOf(buffer[character]))[1];
            GraphicsUtil.drawQuads(x + offset, y, width, height);
            offset += width;
        }
        GL11.glPopMatrix();
        GL11.glDisable(3042);
        GL11.glDisable(3008);
        this.lastRenderedWidth = offset;
        RenderSystem.glColor(Color.white);
        return 0;
    }

    public int getStringWidth(String text) {
        FontMetrics fontMetrics = new Canvas().getFontMetrics(this.stdFont);
        return text != null && fontMetrics != null ? fontMetrics.charsWidth(text.toCharArray(), 0, text.length()) : 0;
    }

    public int getStringHeight(String text) {
        FontMetrics fontMetrics = new Canvas().getFontMetrics(this.stdFont);
        return fontMetrics.getHeight();
    }

    public int getLastRenderedHeight() {
        return this.lastRenderedHeight;
    }

    public int getLastRenderedWidth() {
        return this.lastRenderedWidth;
    }

    public void destroy() {
        GL11.glBindTexture(3553, 0);
        for (Character key : this.textureIDStore.keySet()) {
            GL11.glDeleteTextures(this.textureIDStore.get(key));
        }
        this.textureIDStore.clear();
        this.textureDimensionsStore.clear();
    }

    public String getFontName() {
        return this.fontName;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
        this.prepareStandardFont();
    }

    public int getShadowSize() {
        return this.shadowSize;
    }

    public void setShadowSize(int shadowSize) {
        this.shadowSize = shadowSize;
    }

    public boolean isAntialiased() {
        return this.antialiased;
    }

    public void setAntialiased(boolean antialiased) {
        this.antialiased = antialiased;
    }

    public boolean isMemorysaving() {
        return this.memorysaving;
    }

    public void setMemorysaving(boolean memorysaving) {
        this.memorysaving = memorysaving;
    }
}

