/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.installer.resources.font;

import java.awt.Font;
import java.util.HashMap;
import me.deftware.installer.Main;
import me.deftware.installer.resources.font.BitmapFont;

public class FontManager {
    private static HashMap<String, BitmapFont> fontStore = new HashMap();
    public static HashMap<String, Font> customFonts = new HashMap();

    public static BitmapFont getFont(String name, int size, int modifiers) {
        String key = name + size + modifiers;
        if (fontStore.containsKey(key)) {
            return fontStore.get(key);
        }
        fontStore.put(key, new BitmapFont(name, size, modifiers));
        return fontStore.get(key);
    }

    public static void registerCustomFont(Font font) {
        customFonts.putIfAbsent(font.getFontName(), font);
    }

    public static void removeFont(String name, int size, int modifiers) {
        fontStore.remove(name + size + modifiers);
    }

    public static void clearCache() {
        fontStore.clear();
        customFonts.clear();
    }

    public static void loadFontFromAssets(String path) throws Exception {
        Font customFont = Font.createFont(0, Main.class.getResourceAsStream(path));
        FontManager.registerCustomFont(customFont);
    }

    public static class Modifiers {
        public static byte ANTIALIASED = (byte)32;
    }
}

