/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.installer.screen;

import java.util.function.Consumer;
import me.deftware.installer.screen.AbstractScreen;

public abstract class AbstractComponent<T> {
    protected float x;
    protected float y;
    protected boolean visible = true;
    protected boolean focused = false;
    protected String tooltip = "";
    protected int fadeStatus = 0;
    protected int alpha = 255;
    protected double iterations = 50.0;
    protected double i = 0.0;
    protected double counter = 0.0;
    protected double increase = Math.PI / this.iterations;
    protected Consumer<Integer> fadeCallback;

    public AbstractComponent(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public abstract float getWidth();

    public abstract float getHeight();

    public abstract void render(float var1, float var2, double var3, double var5);

    public void update() {
        if (this.fadeStatus != 0) {
            if (this.i <= 1.0 && (this.fadeStatus == 2 && this.alpha > 3 || this.fadeStatus == 1 && this.alpha < 255)) {
                double current = Math.sin(this.counter) * (255.0 / this.iterations * this.counter);
                this.alpha = (int)(this.fadeStatus == 2 ? (double)this.alpha - current : (double)this.alpha + current);
                this.counter += this.increase;
                this.i += 1.0 / this.iterations;
            } else {
                this.fadeStatus = 0;
                this.i = 0.0;
                this.counter = 0.0;
                if (this.fadeCallback != null) {
                    this.fadeCallback.accept(this.alpha);
                }
            }
        }
    }

    public abstract boolean mouseClicked(double var1, double var3, int var5);

    public abstract void mouseReleased(double var1, double var3, int var5);

    public abstract void charTyped(char var1);

    public abstract void keyPressed(int var1, int var2);

    public abstract void onScroll(double var1, double var3);

    public int cursorTest(double mouseX, double mouseY) {
        return 221185;
    }

    public void deFocus() {
    }

    public AbstractComponent<T> centerHorizontally(float offset) {
        this.x = AbstractScreen.getWindowWidth() / 2.0f - this.getWidth() / 2.0f + offset;
        return this;
    }

    public AbstractComponent<T> centerHorizontally() {
        return this.centerHorizontally(0.0f);
    }

    public AbstractComponent<T> centerVertically(float offset) {
        this.y = AbstractScreen.getWindowHeight() / 2.0f - this.getHeight() / 2.0f + offset;
        return this;
    }

    public AbstractComponent<T> centerVertically() {
        return this.centerVertically(0.0f);
    }

    public AbstractComponent<T> center() {
        return this.centerHorizontally().centerVertically();
    }

    public void fadeOut(Consumer<Integer> callback) {
        this.fadeCallback = callback;
        this.fadeStatus = 2;
    }

    public void fadeIn(Consumer<Integer> callback) {
        this.fadeCallback = callback;
        this.fadeStatus = 1;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public void setTooltip(String tooltip) {
        this.tooltip = tooltip;
    }

    public int getFadeStatus() {
        return this.fadeStatus;
    }

    public int getAlpha() {
        return this.alpha;
    }

    public void setFadeStatus(int fadeStatus) {
        this.fadeStatus = fadeStatus;
    }

    public void setAlpha(int alpha) {
        this.alpha = alpha;
    }
}

