/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.installer.screen;

import java.awt.Color;
import java.awt.Desktop;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.deftware.installer.Main;
import me.deftware.installer.engine.MainWindow;
import me.deftware.installer.engine.theming.ThemeEngine;
import me.deftware.installer.resources.RenderSystem;
import me.deftware.installer.screen.AbstractComponent;
import me.deftware.installer.screen.components.TextComponent;
import org.lwjgl.glfw.GLFW;

public abstract class AbstractScreen {
    private TextComponent tooltipFont;
    private int x = 0;
    private int y = 0;
    protected List<AbstractComponent<?>> componentList = new ArrayList();
    protected boolean initialized = false;

    protected void addComponent(AbstractComponent<?> ... components) {
        this.componentList.addAll(Arrays.asList(components));
    }

    public void render(double mouseX, double mouseY) {
        String tooltip = "";
        int cursor = 221185;
        for (int i = this.componentList.size() - 1; i > -1; --i) {
            AbstractComponent<?> component = this.componentList.get(i);
            if (!component.isVisible()) continue;
            component.render((float)this.x + component.getX(), (float)this.y + component.getY(), mouseX, mouseY);
            if (mouseX > (double)component.getX() && mouseX < (double)(component.getX() + component.getWidth()) && mouseY > (double)component.getY() && mouseY < (double)(component.getY() + component.getHeight()) && !component.getTooltip().isEmpty()) {
                tooltip = component.getTooltip();
            }
            if (cursor != 221185) continue;
            cursor = component.cursorTest(mouseX, mouseY);
        }
        if (!MainWindow.getCursorCache().containsKey(cursor)) {
            MainWindow.getCursorCache().put(cursor, GLFW.glfwCreateStandardCursor(cursor));
        }
        GLFW.glfwSetCursor(Main.getWindow().getWindowHandle(), MainWindow.getCursorCache().get(cursor));
        if (!tooltip.isEmpty() && this.tooltipFont != null) {
            String[] stringArray;
            float offset = 20.0f;
            float textOffset = 3.0f;
            float textWidth = this.tooltipFont.getStringWidth(tooltip);
            float textHeight = this.tooltipFont.getHeight();
            if (tooltip.contains("/n")) {
                textWidth = 0.0f;
                for (String line : tooltip.split("/n")) {
                    if (!(textWidth < (float)this.tooltipFont.getStringWidth(line))) continue;
                    textWidth = this.tooltipFont.getStringWidth(line);
                }
                textHeight *= (float)tooltip.split("/n").length;
            }
            RenderSystem.drawRect((float)mouseX + offset - textOffset + 2.0f, (float)mouseY + offset + 2.0f, (float)mouseX + offset + textWidth + textOffset * 2.0f + 2.0f, (float)mouseY + offset + textHeight + 2.0f, ThemeEngine.getTheme().getTooltipBackground().darker());
            RenderSystem.drawRect((float)mouseX + offset - textOffset, (float)mouseY + offset, (float)mouseX + offset + textWidth + textOffset * 2.0f, (float)mouseY + offset + textHeight, ThemeEngine.getTheme().getTooltipBackground());
            float f = (float)mouseX + offset + textOffset;
            float f2 = (float)mouseY + offset;
            Color color = ThemeEngine.getTheme().getTextColor();
            if (tooltip.contains("/n")) {
                stringArray = tooltip.split("/n");
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = tooltip;
            }
            this.tooltipFont.drawString(f, f2, color, stringArray);
        }
    }

    public void update() {
        for (AbstractComponent<?> component : this.componentList) {
            component.update();
        }
    }

    public void mouseClicked(double x, double y, int button) {
        boolean deFocus = false;
        for (AbstractComponent<?> component : this.componentList) {
            if (!deFocus && component.mouseClicked(x, y, button)) {
                deFocus = true;
                continue;
            }
            if (!deFocus) continue;
            component.deFocus();
        }
    }

    public void mouseReleased(double x, double y, int button) {
        for (AbstractComponent<?> component : this.componentList) {
            component.mouseReleased(x, y, button);
        }
    }

    public void onScroll(double xPos, double yPos) {
        for (AbstractComponent<?> component : this.componentList) {
            component.onScroll(xPos, yPos);
        }
    }

    public void keyPressed(int keyCode, int mods) {
        for (AbstractComponent<?> component : this.componentList) {
            component.keyPressed(keyCode, mods);
        }
    }

    public void charTyped(char charTyped) {
        for (AbstractComponent<?> component : this.componentList) {
            component.charTyped(charTyped);
        }
    }

    public static void openLink(String link) {
        try {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(new URI(link));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void onWindowResize() {
        this.init();
    }

    public static float getWindowWidth() {
        return Main.window.windowWidth;
    }

    public static float getWindowHeight() {
        return Main.window.windowHeight;
    }

    public abstract void init();

    public void initSuper() {
        if (!this.initialized) {
            this.initialized = true;
            this.tooltipFont = new TextComponent(0.0f, 0.0f, 30, "ABC");
            this.tooltipFont.setCenteredText(false);
            this.init();
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public List<AbstractComponent<?>> getComponentList() {
        return this.componentList;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }
}

