/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.installer.screen.components;

import me.deftware.installer.engine.theming.ThemeEngine;
import me.deftware.installer.resources.RenderSystem;
import me.deftware.installer.screen.components.TextBoxComponent;
import me.deftware.installer.screen.components.effects.BlendableEffect;
import org.lwjgl.util.tinyfd.TinyFileDialogs;

public class BrowsableTextBoxComponent
extends TextBoxComponent {
    private final BlendableEffect blendableEffect = new BlendableEffect();
    private boolean mouseOver = false;

    public BrowsableTextBoxComponent(float x, float y, float width, int fontSize, String text) {
        super(x, y, width, fontSize, text);
        this.setReadOnly(true);
        this.textAllowedWidth -= this.height + 20.0f;
    }

    @Override
    public void render(float x, float y, double mouseX, double mouseY) {
        super.render(x, y, mouseX, mouseY);
        RenderSystem.drawRect(x + this.width - this.height + 1.0f, y + 1.0f, x + this.width - 1.0f, y + this.height - 1.0f, this.blendableEffect.getCurrentColor(this.alpha));
        this.textComponent.drawString((int)(x + this.width - this.height + 9.0f), (int)y, ThemeEngine.getColorWithAlpha(ThemeEngine.getTheme().getTextColor(), this.alpha), "...");
        this.mouseOver = mouseX > (double)(x + this.width - this.height) && mouseX < (double)(x + this.width) && mouseY > (double)y && mouseY < (double)(y + this.height);
    }

    @Override
    public int cursorTest(double x, double y) {
        if (x > (double)this.getX() && x < (double)(this.getX() + this.getWidth()) && y > (double)this.getY() && y < (double)(this.getY() + this.getHeight())) {
            if (x > (double)this.getX() && x < (double)(this.getX() + this.getWidth() - this.height) && y > (double)this.getY() && y < (double)(this.getY() + this.getHeight())) {
                if (!this.readOnly) {
                    return 221186;
                }
            } else {
                return 221188;
            }
        }
        return 221185;
    }

    @Override
    public boolean mouseClicked(double x, double y, int mouseButton) {
        if (x > (double)(this.getX() + this.width - this.height) && x < (double)(this.getX() + this.width) && y > (double)this.getY() && y < (double)(this.getY() + this.height) && mouseButton == 0) {
            String folder = TinyFileDialogs.tinyfd_selectFolderDialog("Select path", "");
            if (folder != null && !folder.isEmpty()) {
                this.text = folder;
            }
            return true;
        }
        return super.mouseClicked(x, y, mouseButton);
    }

    @Override
    public void update() {
        super.update();
        this.blendableEffect.update(this.mouseOver);
    }
}

