/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.installer.screen.components;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import me.deftware.installer.engine.theming.ThemeEngine;
import me.deftware.installer.resources.RenderSystem;
import me.deftware.installer.screen.AbstractComponent;
import me.deftware.installer.screen.components.TextComponent;
import me.deftware.installer.screen.components.effects.BlendableEffect;

public class ButtonComponent
extends AbstractComponent<ButtonComponent> {
    private final TextComponent font;
    private final float width;
    private final float height;
    private String text;
    private final List<Consumer<Integer>> onClickCallbacks = new ArrayList<Consumer<Integer>>();
    private boolean visible = true;
    private boolean mouseOver = false;
    private final BlendableEffect blendableEffect = new BlendableEffect();

    public ButtonComponent(float x, float y, float width, float height, String text, Consumer<Integer> onClick) {
        super(x, y);
        this.width = width + 50.0f;
        this.height = height;
        this.onClickCallbacks.add(onClick);
        this.text = text;
        this.font = new TextComponent(x, y, 23, text);
    }

    @Override
    public void render(float x, float y, double mouseX, double mouseY) {
        if (this.visible) {
            Color bgColor = this.blendableEffect.getCurrentColor(this.alpha);
            RenderSystem.drawRect(x + 25.0f, y, x + this.width - 25.0f, y + this.height, bgColor);
            RenderSystem.drawCircle(x + 25.0f, y + 25.0f, 25.0f, bgColor);
            RenderSystem.drawCircle(x + this.width - 25.0f, y + 25.0f, 25.0f, bgColor);
            this.font.drawString((int)(x + (this.width / 2.0f - this.font.getWidth() / 2.0f)), (int)(y + (this.height / 2.0f - this.font.getHeight() / 2.0f)), ThemeEngine.getColorWithAlpha(ThemeEngine.getTheme().getTextColor(), this.alpha), this.text);
            this.mouseOver = mouseX > (double)this.getX() && mouseX < (double)(this.getX() + this.width) && mouseY > (double)this.getY() && mouseY < (double)(this.getY() + this.height);
        }
    }

    @Override
    public void update() {
        super.update();
        this.blendableEffect.update(this.mouseOver);
    }

    @Override
    public boolean mouseClicked(double x, double y, int mouseButton) {
        if (x > (double)this.getX() && x < (double)(this.getX() + this.width) && y > (double)this.getY() && y < (double)(this.getY() + this.height) && this.visible && mouseButton == 0) {
            for (Consumer<Integer> cb : this.onClickCallbacks) {
                cb.accept(mouseButton);
            }
            return true;
        }
        return false;
    }

    public void setText(String text) {
        this.text = text;
        this.font.setText(text);
    }

    @Override
    public void mouseReleased(double x, double y, int mouseButton) {
    }

    @Override
    public void charTyped(char typedChar) {
    }

    @Override
    public void keyPressed(int keycode, int mods) {
    }

    @Override
    public void onScroll(double xPos, double yPos) {
    }

    public TextComponent getFont() {
        return this.font;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    public String getText() {
        return this.text;
    }

    public List<Consumer<Integer>> getOnClickCallbacks() {
        return this.onClickCallbacks;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

