/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.installer.screen.components;

import java.awt.Color;
import java.util.function.Consumer;
import me.deftware.installer.engine.theming.ThemeEngine;
import me.deftware.installer.resources.RenderSystem;
import me.deftware.installer.resources.ResourceUtils;
import me.deftware.installer.resources.Texture;
import me.deftware.installer.screen.AbstractComponent;
import me.deftware.installer.screen.components.TextComponent;
import me.deftware.installer.screen.components.effects.BlendableEffect;

public class CheckBoxComponent
extends AbstractComponent<CheckBoxComponent> {
    private Texture arrow;
    private final TextComponent font;
    private final float width;
    private final float height;
    private boolean checked = false;
    private String text;
    private Consumer<Boolean> onCheckCallback;
    private final BlendableEffect blendableEffect = new BlendableEffect();
    private boolean mouseOver = false;

    public CheckBoxComponent(float x, float y, String text, int fontSize) {
        super(x, y);
        this.font = new TextComponent(x, y, fontSize, text);
        this.width = this.font.getWidth();
        this.text = text;
        this.height = this.font.getHeight() + 6.0f;
        try {
            this.arrow = ResourceUtils.loadTexture("/assets/down_arrow.png", 15.0f);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public int cursorTest(double x, double y) {
        if (x > (double)this.getX() && x < (double)(this.getX() + this.width + this.height + 5.0f) && y > (double)this.getY() && y < (double)(this.getY() + this.height)) {
            return 221188;
        }
        return 221185;
    }

    @Override
    public void render(float x, float y, double mouseX, double mouseY) {
        this.font.drawString((int)(x + this.height + 10.0f), (int)y + 2, ThemeEngine.getTheme().getTextColor(), this.text);
        RenderSystem.drawRect(x, y, x + this.height, y + this.height, this.blendableEffect.getCurrentColor(this.alpha));
        try {
            if (this.checked) {
                RenderSystem.glColor(ThemeEngine.getTheme().getTextColor());
                this.arrow.draw(x + (this.height / 2.0f - this.arrow.getWidth() / 2.0f), y + (this.height / 2.0f - this.arrow.getHeight() / 2.0f));
                RenderSystem.glColor(Color.white);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.mouseOver = mouseX > (double)x && mouseX < (double)(x + this.height) && mouseY > (double)y && mouseY < (double)(y + this.height);
    }

    @Override
    public boolean mouseClicked(double x, double y, int mouseButton) {
        if (x > (double)this.getX() && x < (double)(this.getX() + this.width + this.height + 5.0f) && y > (double)this.getY() && y < (double)(this.getY() + this.height) && mouseButton == 0) {
            boolean bl = this.checked = !this.checked;
            if (this.onCheckCallback != null) {
                this.onCheckCallback.accept(this.checked);
            }
            return true;
        }
        return false;
    }

    @Override
    public void update() {
        this.blendableEffect.update(this.mouseOver);
    }

    @Override
    public void mouseReleased(double x, double y, int mouseButton) {
    }

    @Override
    public void charTyped(char typedChar) {
    }

    @Override
    public void keyPressed(int keycode, int mods) {
    }

    @Override
    public void onScroll(double xPos, double yPos) {
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setOnCheckCallback(Consumer<Boolean> onCheckCallback) {
        this.onCheckCallback = onCheckCallback;
    }
}

