/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.installer.screen.components;

import java.awt.Color;
import java.util.function.Consumer;
import me.deftware.installer.engine.theming.ThemeEngine;
import me.deftware.installer.resources.RenderSystem;
import me.deftware.installer.resources.ResourceUtils;
import me.deftware.installer.resources.Texture;
import me.deftware.installer.screen.AbstractComponent;
import me.deftware.installer.screen.components.TextComponent;
import me.deftware.installer.screen.components.effects.BlendableEffect;

public class ComboBoxComponent
extends AbstractComponent<ComboBoxComponent> {
    private Texture arrow;
    private TextComponent font;
    private float width;
    private float height;
    private float scrollbarWidth = 17.0f;
    private float scrollbarHeight = 45.0f;
    private float scrollbarY = 0.0f;
    private int index = 0;
    private int hoverIndex = 0;
    private int maxItems = 5;
    private int indexOffset = 0;
    private String[] items;
    private boolean expanded = false;
    private boolean scrollbarDrag = false;
    private Consumer<String> itemChangedCallback;
    private double prevMouseY = 0.0;
    private final BlendableEffect blendableEffect = new BlendableEffect();
    private boolean mouseOver = false;

    public ComboBoxComponent(float x, float y, float width, int fontSize, String ... items) {
        super(x, y);
        this.font = new TextComponent(x, y, fontSize, items[0]);
        this.font.setCenteredText(false);
        this.width = width;
        this.height = this.font.getHeight() + 6.0f;
        this.items = items;
        this.maxItems = items.length + 1 < this.maxItems ? items.length : this.maxItems;
        try {
            this.arrow = ResourceUtils.loadTexture("/assets/down_arrow.png", 25.0f);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.itemChangedCallback != null) {
            this.itemChangedCallback.accept(this.getSelectedItem());
        }
    }

    public void updateItems(String ... items) {
        this.indexOffset = 0;
        this.index = 0;
        this.items = items;
        this.maxItems = items.length + 1 < 5 ? items.length : 5;
    }

    public String getSelectedItem() {
        return this.items[this.index];
    }

    public boolean hasScrolling() {
        return this.items.length + 1 >= 5;
    }

    @Override
    public void render(float x, float y, double mouseX, double mouseY) {
        RenderSystem.drawRect(x, y, x + this.width, y + this.height * (float)(this.expanded ? this.maxItems + 1 : 1), ThemeEngine.getTheme().getOutlineColor());
        RenderSystem.drawRect(x + 1.0f, y + 1.0f, x + this.width - 1.0f, y + this.height * (float)(this.expanded ? this.maxItems + 1 : 1) - 1.0f, ThemeEngine.getTheme().getBackgroundColor());
        this.font.drawString((int)x + 6, (int)y + 3, ThemeEngine.getColorWithAlpha(ThemeEngine.getTheme().getTextColor(), this.alpha), this.getSelectedItem());
        RenderSystem.drawRect(x + this.width - this.height + 1.0f, y + 1.0f, x + this.width - 1.0f, y + this.height - 1.0f, this.blendableEffect.getCurrentColor(this.alpha));
        try {
            RenderSystem.glColor(ThemeEngine.getTheme().getTextColor());
            this.arrow.draw(x + this.width - this.height + (this.height / 2.0f - this.arrow.getWidth() / 2.0f), y + (this.height / 2.0f - this.arrow.getHeight() / 2.0f));
            RenderSystem.glColor(Color.white);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.expanded) {
            float oriY = y;
            y = y + 6.0f + this.font.getHeight();
            int loopIndex = 0;
            this.hoverIndex = -1;
            for (String item : this.items) {
                if (loopIndex >= this.indexOffset && loopIndex - this.indexOffset < this.maxItems) {
                    if (mouseY > (double)(y - 1.0f) && mouseY < (double)(y + 6.0f + this.font.getHeight()) && mouseX > (double)x && mouseX < (double)(x + this.width - this.scrollbarWidth)) {
                        RenderSystem.drawRect(x + 1.0f, y - 1.0f, x + this.width - 1.0f, y + 5.0f + this.font.getHeight(), ThemeEngine.getTheme().getForegroundColor());
                        this.hoverIndex = loopIndex;
                    }
                    this.font.drawString((int)x + 6, (int)y, ThemeEngine.getColorWithAlpha(ThemeEngine.getTheme().getTextColor(), this.alpha), item);
                    y += 6.0f + this.font.getHeight();
                }
                ++loopIndex;
            }
            RenderSystem.drawLine(x, oriY + this.height - 1.0f, x + this.width, oriY + this.height, ThemeEngine.getTheme().getOutlineColor());
            if (this.hasScrolling()) {
                y = oriY;
                RenderSystem.drawRect(x + this.width - this.scrollbarWidth, y + this.height + 1.0f, x + this.width - 1.0f, y + this.height * (float)(this.maxItems + 1) - 1.0f, ThemeEngine.getTheme().getScrollerBackgroundColor());
                if (this.indexOffset != 0) {
                    float offset = (float)this.maxItems * this.height / (float)this.items.length;
                    y += (float)this.indexOffset * offset;
                }
                this.scrollbarY = y;
                RenderSystem.drawRect(x + this.width - this.scrollbarWidth, y + this.height + 1.0f, x + this.width - 1.0f, y + this.height + 3.0f + this.scrollbarHeight, ThemeEngine.getTheme().getScrollerColor());
            }
        }
        this.prevMouseY = mouseY;
        this.mouseOver = mouseX > (double)(x + this.width - this.height) && mouseX < (double)(x + this.width) && mouseY > (double)y && mouseY < (double)(y + this.height);
    }

    @Override
    public int cursorTest(double x, double y) {
        if (x > (double)(this.getX() + this.getWidth() - this.height) && x < (double)(this.getX() + this.getWidth()) && y > (double)this.getY() && y < (double)(this.getY() + this.getHeight())) {
            return 221188;
        }
        return 221185;
    }

    @Override
    public void onScroll(double xPos, double yPos) {
        if (this.expanded && this.maxItems < this.items.length + 1 && (double)this.indexOffset + -yPos > -1.0 && (double)this.indexOffset + -yPos < (double)(this.items.length + 1 - this.maxItems)) {
            this.indexOffset = (int)((double)this.indexOffset + -yPos);
        }
    }

    @Override
    public void update() {
        if (!(!this.scrollbarDrag || this.prevMouseY > (double)(this.scrollbarY + this.height) && this.prevMouseY < (double)(this.scrollbarY + this.height + this.scrollbarHeight))) {
            if ((double)(this.scrollbarY + this.height) < this.prevMouseY) {
                this.onScroll(0.0, -1.0);
            } else {
                this.onScroll(0.0, 1.0);
            }
        }
        this.blendableEffect.update(this.mouseOver);
    }

    @Override
    public boolean mouseClicked(double x, double y, int mouseButton) {
        boolean prevValue = this.expanded;
        if (x > (double)this.getX() && x < (double)(this.getX() + this.width) && y > (double)this.getY() && y < (double)(this.getY() + this.height) && mouseButton == 0) {
            this.expanded = !this.expanded;
        } else if (this.expanded) {
            if (this.hoverIndex != -1) {
                this.index = this.hoverIndex;
                if (this.itemChangedCallback != null) {
                    this.itemChangedCallback.accept(this.getSelectedItem());
                }
                this.expanded = false;
            } else if (x > (double)(this.getX() + this.width - this.scrollbarWidth) && x < (double)(this.getX() + this.width) && y > (double)(this.getY() + this.height) && y < (double)(this.getY() + this.height * (float)(this.maxItems + 1))) {
                this.scrollbarDrag = true;
            } else {
                this.expanded = false;
            }
            return true;
        }
        if (prevValue && !this.expanded) {
            this.indexOffset = 0;
        }
        return false;
    }

    @Override
    public void mouseReleased(double x, double y, int mouseButton) {
        this.scrollbarDrag = false;
    }

    @Override
    public void charTyped(char typedChar) {
    }

    @Override
    public void keyPressed(int keycode, int mods) {
    }

    public TextComponent getFont() {
        return this.font;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    public float getScrollbarWidth() {
        return this.scrollbarWidth;
    }

    public float getScrollbarHeight() {
        return this.scrollbarHeight;
    }

    public float getScrollbarY() {
        return this.scrollbarY;
    }

    public int getIndex() {
        return this.index;
    }

    public int getHoverIndex() {
        return this.hoverIndex;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    public int getIndexOffset() {
        return this.indexOffset;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setHoverIndex(int hoverIndex) {
        this.hoverIndex = hoverIndex;
    }

    public void setMaxItems(int maxItems) {
        this.maxItems = maxItems;
    }

    public void setIndexOffset(int indexOffset) {
        this.indexOffset = indexOffset;
    }

    public void setItemChangedCallback(Consumer<String> itemChangedCallback) {
        this.itemChangedCallback = itemChangedCallback;
    }
}

