/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.installer.screen.components;

import com.google.common.io.ByteStreams;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import me.deftware.installer.Main;
import me.deftware.installer.resources.GifDecoder;
import me.deftware.installer.resources.ResourceUtils;
import me.deftware.installer.resources.Texture;
import me.deftware.installer.screen.AbstractComponent;

public class GifTextureComponent
extends AbstractComponent<GifTextureComponent> {
    private final List<GifSlice> slices = new ArrayList<GifSlice>();
    private int delay = 0;
    private int index = 0;
    private float width;
    private float height;
    private int scale;
    private int speedOverride;
    private boolean fillScreen = false;
    private final String asset;

    public GifTextureComponent(float x, float y, String asset, int scale, int speedOverride) {
        super(x, y);
        this.scale = scale;
        this.speedOverride = speedOverride;
        this.asset = asset;
    }

    public GifTextureComponent init() {
        try {
            GifDecoder.GifImage gif = GifDecoder.read(ByteStreams.toByteArray(ResourceUtils.getStreamFromResources(this.asset)));
            for (int i = 0; i < gif.getFrameCount(); ++i) {
                BufferedImage img = gif.getFrame(i);
                this.width = img.getWidth() / this.scale;
                this.height = img.getHeight() / this.scale;
                this.slices.add(new GifSlice(img, gif.getDelay(i), i));
            }
            if (this.fillScreen) {
                this.width = Main.getWindow().windowWidth;
                this.height = Main.getWindow().windowHeight;
            }
            Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(() -> {
                if (this.delay == this.slices.get((int)this.index).delay) {
                    this.delay = 0;
                    this.index = this.index == this.slices.size() - 1 ? 0 : this.index + 1;
                    return;
                }
                ++this.delay;
            }, 0L, 10L, TimeUnit.MILLISECONDS);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this;
    }

    public GifTextureComponent setFillScreen(boolean fillScreen) {
        this.fillScreen = fillScreen;
        return this;
    }

    @Override
    public void render(float x, float y, double mouseX, double mouseY) {
        this.slices.get(this.index).render(x, y);
    }

    @Override
    public void update() {
    }

    @Override
    public boolean mouseClicked(double x, double y, int mouseButton) {
        return false;
    }

    @Override
    public void mouseReleased(double x, double y, int mouseButton) {
    }

    @Override
    public void charTyped(char typedChar) {
    }

    @Override
    public void keyPressed(int keycode, int mods) {
    }

    @Override
    public void onScroll(double xPos, double yPos) {
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    public int getScale() {
        return this.scale;
    }

    public int getSpeedOverride() {
        return this.speedOverride;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public void setSpeedOverride(int speedOverride) {
        this.speedOverride = speedOverride;
    }

    private class GifSlice {
        Texture texture;
        int delay;
        int index;

        GifSlice(BufferedImage texture, int delay, int index) {
            this.texture = GifTextureComponent.this.fillScreen ? ResourceUtils.loadTextureFromBufferedImage(texture, Main.getWindow().windowWidth, Main.getWindow().windowHeight) : ResourceUtils.loadTextureFromBufferedImage(texture, GifTextureComponent.this.scale);
            this.delay = GifTextureComponent.this.speedOverride == -1 ? delay : GifTextureComponent.this.speedOverride;
            this.index = index;
        }

        void render(float x, float y) {
            try {
                this.texture.draw(x, y);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

