/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.installer.screen.components;

import java.util.Objects;
import java.util.function.Consumer;
import me.deftware.installer.Main;
import me.deftware.installer.engine.theming.ThemeEngine;
import me.deftware.installer.resources.RenderSystem;
import me.deftware.installer.screen.AbstractComponent;
import me.deftware.installer.screen.components.TextComponent;
import org.lwjgl.glfw.GLFW;

public class TextBoxComponent
extends AbstractComponent<TextBoxComponent> {
    protected String text;
    protected float width;
    protected float height;
    protected String shadowText = "";
    protected TextComponent textComponent;
    protected int maxTextLength = 300;
    protected boolean readOnly = false;
    protected Consumer<String> onChangedCallback;
    protected float textAllowedWidth;
    protected long lastMs = System.currentTimeMillis();
    protected boolean cursorTick = false;
    protected boolean selecting = false;
    protected int firstCharacterIndex;
    protected int selectionStart;
    protected int selectionEnd;

    public TextBoxComponent(float x, float y, float width, int fontSize, String text) {
        super(x, y);
        this.width = width;
        this.textComponent = new TextComponent(x, y, fontSize, text);
        this.textComponent.setCenteredText(false);
        this.height = this.textComponent.getHeight();
        this.text = text;
        this.textAllowedWidth = width;
    }

    public void setText(String text) {
        this.text = text.length() > this.maxTextLength ? text.substring(0, this.maxTextLength) : text;
        this.setCursor(this.text.length());
        this.setSelectionEnd(this.selectionStart);
        this.onChanged(text);
    }

    private void appendText(String string) {
        int length;
        int minSelection = Math.min(this.selectionStart, this.selectionEnd);
        int maxSelection = Math.max(this.selectionStart, this.selectionEnd);
        int deltaLength = this.maxTextLength - this.text.length() - (minSelection - maxSelection);
        if (deltaLength < (length = string.length())) {
            string = string.substring(0, deltaLength);
            length = deltaLength;
        }
        this.text = new StringBuilder(this.text).replace(minSelection, maxSelection, string).toString();
        this.setSelectionStart(minSelection + length);
        this.setSelectionEnd(this.selectionStart);
        this.onChanged(this.text);
    }

    public String getSelectedText() {
        return this.text.substring(Math.min(this.selectionStart, this.selectionEnd), Math.max(this.selectionStart, this.selectionEnd));
    }

    private void onChanged(String newText) {
        if (this.onChangedCallback != null) {
            this.onChangedCallback.accept(newText);
        }
    }

    private void backspaceWords(int wordOffset) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.selectionStart) {
                this.appendText("");
            } else {
                this.backspaceCharacters(this.getWordSkipPosition(wordOffset) - this.selectionStart);
            }
        }
    }

    private void backspaceCharacters(int characterOffset) {
        if (!this.text.isEmpty()) {
            if (this.selectionEnd != this.selectionStart) {
                this.appendText("");
            } else {
                int maxPosition;
                int cursorPosition = this.moveCursor(this.text, this.selectionStart, characterOffset);
                int minPosition = Math.min(cursorPosition, this.selectionStart);
                if (minPosition != (maxPosition = Math.max(cursorPosition, this.selectionStart))) {
                    this.text = new StringBuilder(this.text).delete(minPosition, maxPosition).toString();
                    this.setCursor(minPosition);
                }
            }
        }
    }

    private int getWordSkipPosition(int wordOffset) {
        int cursorPosition = this.selectionStart;
        for (int i = 0; i < Math.abs(wordOffset); ++i) {
            if (wordOffset > 0) {
                int length = this.text.length();
                if ((cursorPosition = this.text.indexOf(this.maxTextLength, cursorPosition)) == -1) {
                    cursorPosition = length;
                    continue;
                }
                while (cursorPosition < length && this.text.charAt(cursorPosition) == ' ') {
                    ++cursorPosition;
                }
                continue;
            }
            while (cursorPosition > 0 && this.text.charAt(cursorPosition - 1) == ' ') {
                --cursorPosition;
            }
            while (cursorPosition > 0 && this.text.charAt(cursorPosition - 1) != ' ') {
                --cursorPosition;
            }
        }
        return cursorPosition;
    }

    private void setSelectionEnd(int i) {
        int j = this.text.length();
        this.selectionEnd = TextBoxComponent.clamp(i, 0, j);
        if (this.firstCharacterIndex > j) {
            this.firstCharacterIndex = j;
        }
        String string = this.textComponent.trimToWidth(this.text.substring(this.firstCharacterIndex), this.textAllowedWidth);
        int l = string.length() + this.firstCharacterIndex;
        if (this.selectionEnd == this.firstCharacterIndex) {
            this.firstCharacterIndex -= this.textComponent.trimToWidthReverse(this.text, this.textAllowedWidth).length();
        }
        if (this.selectionEnd > l) {
            this.firstCharacterIndex += this.selectionEnd - l;
        } else if (this.selectionEnd <= this.firstCharacterIndex) {
            this.firstCharacterIndex -= this.firstCharacterIndex - this.selectionEnd;
        }
        this.firstCharacterIndex = TextBoxComponent.clamp(this.firstCharacterIndex, 0, j);
    }

    private int moveCursor(int delta) {
        return this.moveCursor(this.text, this.selectionStart, delta);
    }

    private int moveCursor(String string, int cursor, int delta) {
        int i = string.length();
        if (delta >= 0) {
            for (int j = 0; cursor < i && j < delta; ++j) {
                if (!Character.isHighSurrogate(string.charAt(cursor++)) || cursor >= i || !Character.isLowSurrogate(string.charAt(cursor))) continue;
                ++cursor;
            }
        } else {
            for (int j = delta; cursor > 0 && j < 0; ++j) {
                if (!Character.isLowSurrogate(string.charAt(--cursor)) || cursor <= 0 || !Character.isHighSurrogate(string.charAt(cursor - 1))) continue;
                --cursor;
            }
        }
        return cursor;
    }

    private static int clamp(int value, int min2, int max) {
        if (value < min2) {
            return min2;
        }
        return Math.min(value, max);
    }

    private void setCursor(int cursor) {
        this.setSelectionStart(cursor);
        if (!this.selecting) {
            this.setSelectionEnd(this.selectionStart);
        }
        this.onChanged(this.text);
    }

    private void setSelectionStart(int cursor) {
        this.selectionStart = TextBoxComponent.clamp(cursor, 0, this.text.length());
    }

    @Override
    public void render(float x, float y, double mouseX, double mouseY) {
        boolean lengthOutsideBounds;
        RenderSystem.drawRect(x, y, x + this.width, y + this.height, ThemeEngine.getTheme().getOutlineColor());
        RenderSystem.drawRect(x + 1.0f, y + 1.0f, x + this.width - 1.0f, y + this.height - 1.0f, ThemeEngine.getTheme().getBackgroundColor());
        int deltaStart = this.selectionStart - this.firstCharacterIndex;
        int deltaEnd = this.selectionEnd - this.firstCharacterIndex;
        String drawString = this.textComponent.trimToWidth(this.text.substring(this.firstCharacterIndex), this.textAllowedWidth);
        boolean bl = lengthOutsideBounds = deltaStart >= 0 && deltaStart <= drawString.length();
        if (deltaEnd > drawString.length()) {
            deltaEnd = drawString.length();
        }
        float xPos = x;
        if (!drawString.isEmpty()) {
            xPos = this.textComponent.drawString(x + 3.0f, y, ThemeEngine.getTheme().getTextColor(), lengthOutsideBounds ? drawString.substring(0, deltaStart) : drawString);
        }
        if (!drawString.isEmpty() && lengthOutsideBounds && deltaStart < drawString.length()) {
            this.textComponent.drawString(xPos, y, ThemeEngine.getTheme().getTextColor(), drawString.substring(deltaStart));
        }
        if (!lengthOutsideBounds) {
            float f = xPos = deltaStart > 0 ? x + this.textAllowedWidth : x;
        }
        if (this.text.isEmpty() && !this.shadowText.isEmpty()) {
            this.textComponent.drawString(x + 3.0f, y, ThemeEngine.getTheme().getTextColor().darker(), this.shadowText);
        }
        if (this.cursorTick && this.focused) {
            if (this.selectionStart < this.text.length() || this.text.length() >= this.getMaxTextLength()) {
                RenderSystem.drawRect(xPos, y, xPos + 1.0f, y + this.height, ThemeEngine.getTheme().getTextColor());
            } else {
                this.textComponent.drawString(xPos + (float)(this.text.isEmpty() && !this.shadowText.isEmpty() ? 3 : 0), y, ThemeEngine.getTheme().getTextColor(), "_");
            }
        }
        if (deltaEnd != deltaStart) {
            RenderSystem.drawRect(xPos, y, x + (float)this.textComponent.getStringWidth(drawString.substring(0, deltaEnd)), y + this.height, ThemeEngine.getColorWithAlpha(ThemeEngine.getTheme().getTextHighlightColor(), 100.0f));
        }
    }

    @Override
    public boolean mouseClicked(double x, double y, int mouseButton) {
        if (this.readOnly) {
            return false;
        }
        boolean prevState = this.focused;
        boolean bl = this.focused = x > (double)this.getX() && x < (double)(this.getX() + this.getWidth()) && y > (double)this.getY() && y < (double)(this.getY() + this.getHeight());
        if (this.focused && mouseButton == 2) {
            this.appendText(Objects.requireNonNull(GLFW.glfwGetClipboardString(Main.getWindow().windowHandle)));
        } else {
            this.focused &= mouseButton == 0;
        }
        if (this.focused) {
            String string = this.textComponent.trimToWidth(this.text.substring(this.firstCharacterIndex), this.textAllowedWidth);
            this.setCursor(this.textComponent.trimToWidth(string, (float)Math.floor(x) - this.x).length() + this.firstCharacterIndex);
        } else {
            this.selecting = false;
        }
        if (!prevState && this.focused) {
            this.lastMs = System.currentTimeMillis();
            this.cursorTick = true;
            return true;
        }
        return false;
    }

    @Override
    public void charTyped(char typedChar) {
        if (!this.readOnly && this.focused) {
            this.appendText(Character.toString(typedChar));
        }
    }

    @Override
    public int cursorTest(double x, double y) {
        if (x > (double)this.getX() && x < (double)(this.getX() + this.getWidth()) && y > (double)this.getY() && y < (double)(this.getY() + this.getHeight()) && !this.readOnly) {
            return 221186;
        }
        return 221185;
    }

    @Override
    public void deFocus() {
        this.focused = false;
    }

    @Override
    public void update() {
        super.update();
        if (this.focused && this.lastMs + 500L < System.currentTimeMillis()) {
            this.lastMs = System.currentTimeMillis();
            this.cursorTick = !this.cursorTick;
        }
    }

    @Override
    public void keyPressed(int keycode, int mods) {
        if (this.readOnly || !this.focused) {
            return;
        }
        boolean selecting = mods == 1;
        boolean ctrlKey = mods == 2;
        this.selecting = selecting;
        if (ctrlKey && keycode == 65) {
            this.setCursor(this.text.length());
            this.setSelectionEnd(0);
        } else if (ctrlKey && keycode == 67) {
            GLFW.glfwSetClipboardString(Main.getWindow().windowHandle, this.getSelectedText());
        } else if (ctrlKey && keycode == 86) {
            this.appendText(Objects.requireNonNull(GLFW.glfwGetClipboardString(Main.getWindow().windowHandle)));
        } else if (ctrlKey && keycode == 88) {
            GLFW.glfwSetClipboardString(Main.getWindow().windowHandle, this.getSelectedText());
            this.appendText("");
        } else {
            switch (keycode) {
                case 259: {
                    this.selecting = false;
                    if (ctrlKey) {
                        this.backspaceWords(-1);
                    } else {
                        this.backspaceCharacters(-1);
                    }
                    this.selecting = selecting;
                    break;
                }
                case 262: 
                case 263: {
                    if (ctrlKey) {
                        this.setCursor(this.getWordSkipPosition(keycode == 263 ? -1 : 1));
                        break;
                    }
                    this.setCursor(this.moveCursor(keycode == 263 ? -1 : 1));
                    break;
                }
                case 268: {
                    this.setCursor(0);
                    break;
                }
                case 269: {
                    this.setCursor(this.text.length());
                }
            }
        }
    }

    @Override
    public void onScroll(double xPos, double yPos) {
    }

    @Override
    public void mouseReleased(double x, double y, int mouseButton) {
    }

    public String getText() {
        return this.text;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    public void setShadowText(String shadowText) {
        this.shadowText = shadowText;
    }

    public TextComponent getTextComponent() {
        return this.textComponent;
    }

    public int getMaxTextLength() {
        return this.maxTextLength;
    }

    public void setMaxTextLength(int maxTextLength) {
        this.maxTextLength = maxTextLength;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setOnChangedCallback(Consumer<String> onChangedCallback) {
        this.onChangedCallback = onChangedCallback;
    }

    public void setTextAllowedWidth(float textAllowedWidth) {
        this.textAllowedWidth = textAllowedWidth;
    }
}

