/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.installer.screen.components;

import java.awt.Color;
import java.util.function.Consumer;
import me.deftware.installer.engine.theming.ThemeEngine;
import me.deftware.installer.resources.font.BitmapFont;
import me.deftware.installer.resources.font.FontManager;
import me.deftware.installer.screen.AbstractComponent;

public class TextComponent
extends AbstractComponent<TextComponent> {
    private BitmapFont font;
    private Consumer<Integer> clickCallback;
    private String[] text;
    private boolean centeredText = true;
    private boolean customFont = false;
    private final int fontSize;

    public TextComponent(float x, float y, int size, String ... text) {
        this(x, y, size, (Consumer<Integer>)null, text);
    }

    public TextComponent(float x, float y, int size, Consumer<Integer> clickCallback, String ... text) {
        super(x, y);
        this.text = text;
        this.clickCallback = clickCallback;
        this.fontSize = size;
        this.setupFont();
    }

    private void setupFont() {
        try {
            this.font = FontManager.getFont(ThemeEngine.getTheme().getTextFont(), this.fontSize, FontManager.Modifiers.ANTIALIASED);
            this.font.setShadowSize(1);
            this.font.initialize(Color.white, "");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setText(String ... text) {
        this.text = text;
    }

    public void setCustomFont(String fontName) {
        this.customFont = true;
        this.setupFont();
    }

    @Override
    public void update() {
        super.update();
    }

    @Override
    public float getWidth() {
        int maxLength = 0;
        for (String line : this.text) {
            if (maxLength >= this.font.getStringWidth(line)) continue;
            maxLength = this.font.getStringWidth(line);
        }
        return maxLength;
    }

    @Override
    public float getHeight() {
        return this.font.getStringHeight("ABC123") * this.text.length;
    }

    public String trimToWidthReverse(String text, float maxWidth) {
        int offsetIndex = 0;
        for (int i = text.length(); i > -1; --i) {
            if (!((float)this.getStringWidth(text.substring(i)) > maxWidth)) continue;
            offsetIndex = i;
            break;
        }
        return text.substring(offsetIndex);
    }

    public String trimToWidth(String text, float maxWidth) {
        int numChars = 0;
        for (int i = 0; i < text.length() && !((float)this.getStringWidth(text.substring(0, i)) > maxWidth); ++i) {
            ++numChars;
        }
        return text.substring(0, numChars);
    }

    @Override
    public void render(float x, float y, double mouseX, double mouseY) {
        this.drawString(x, y, ThemeEngine.getColorWithAlpha(ThemeEngine.getTheme().getTextColor(), this.alpha), this.text);
        if (!this.font.getFontName().equalsIgnoreCase(ThemeEngine.getTheme().getTextFont()) && !this.customFont) {
            this.setupFont();
        }
    }

    public float drawString(float x, float y, Color color, String ... text) {
        for (String line : text) {
            if (!this.centeredText) {
                this.font.drawString((int)x, (int)y, line, color);
            } else {
                this.font.drawString((int)(x + (this.getWidth() / 2.0f - (float)(this.font.getStringWidth(line) / 2))), (int)y, line, color);
            }
            y += (float)this.font.getStringHeight(line);
        }
        return x + (float)this.font.getStringWidth(text[0]);
    }

    public int getStringWidth(String s2) {
        return this.font.getStringWidth(s2);
    }

    @Override
    public boolean mouseClicked(double x, double y, int mouseButton) {
        if (x > (double)this.getX() && x < (double)(this.getX() + this.getWidth()) && y > (double)this.getY() && y < (double)(this.getY() + this.getHeight()) && this.clickCallback != null && mouseButton == 0) {
            this.clickCallback.accept(mouseButton);
            return true;
        }
        return false;
    }

    @Override
    public void mouseReleased(double x, double y, int mouseButton) {
    }

    @Override
    public void charTyped(char typedChar) {
    }

    @Override
    public void keyPressed(int keycode, int mods) {
    }

    @Override
    public void onScroll(double xPos, double yPos) {
    }

    public void setClickCallback(Consumer<Integer> clickCallback) {
        this.clickCallback = clickCallback;
    }

    public String[] getText() {
        return this.text;
    }

    public boolean isCenteredText() {
        return this.centeredText;
    }

    public void setCenteredText(boolean centeredText) {
        this.centeredText = centeredText;
    }
}

