/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.installer.screen.components;

import java.util.function.Consumer;
import me.deftware.installer.resources.ResourceUtils;
import me.deftware.installer.resources.Texture;
import me.deftware.installer.screen.AbstractComponent;

public class TextureComponent
extends AbstractComponent<TextureComponent> {
    private Texture texture;
    private final Consumer<Integer> clickCallback;

    public TextureComponent(float x, float y, String path) {
        this(x, y, path, 1, null);
    }

    public TextureComponent(float x, float y, String path, Consumer<Integer> clickCallback) {
        this(x, y, path, 1, clickCallback);
    }

    public TextureComponent(float x, float y, String path, int scale) {
        this(x, y, path, scale, null);
    }

    public TextureComponent(float x, float y, String path, int scale, Consumer<Integer> clickCallback) {
        super(x, y);
        try {
            this.texture = ResourceUtils.loadTexture(path, scale);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.clickCallback = clickCallback;
    }

    @Override
    public float getWidth() {
        return this.texture.getWidth();
    }

    @Override
    public float getHeight() {
        return this.texture.getHeight();
    }

    @Override
    public void render(float x, float y, double mouseX, double mouseY) {
        try {
            this.texture.draw(x, y);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void update() {
    }

    @Override
    public boolean mouseClicked(double x, double y, int mouseButton) {
        if (x > (double)this.getX() && x < (double)(this.getX() + this.texture.getWidth()) && y > (double)this.getY() && y < (double)(this.getY() + this.texture.getHeight()) && this.clickCallback != null && mouseButton == 0) {
            this.clickCallback.accept(mouseButton);
            return true;
        }
        return false;
    }

    @Override
    public void mouseReleased(double x, double y, int mouseButton) {
    }

    @Override
    public void charTyped(char typedChar) {
    }

    @Override
    public void keyPressed(int keycode, int mods) {
    }

    @Override
    public void onScroll(double xPos, double yPos) {
    }
}

