/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.installer.screen.impl;

import me.deftware.installer.Main;
import me.deftware.installer.engine.theming.DefaultThemes;
import me.deftware.installer.engine.theming.ThemeEngine;
import me.deftware.installer.screen.AbstractScreen;
import me.deftware.installer.screen.components.BrowsableTextBoxComponent;
import me.deftware.installer.screen.components.ButtonComponent;
import me.deftware.installer.screen.components.CheckBoxComponent;
import me.deftware.installer.screen.components.ComboBoxComponent;
import me.deftware.installer.screen.components.TextBoxComponent;
import me.deftware.installer.screen.components.TextComponent;
import me.deftware.installer.screen.components.TextureComponent;

public class DemoScreen
extends AbstractScreen {
    @Override
    public void init() {
        this.componentList.clear();
        TextComponent textComponent = (TextComponent)new TextComponent(0.0f, 40.0f, 40, "A demo of components").centerHorizontally();
        textComponent.setClickCallback(mouseButton -> System.out.println("Label clicked with mouse button " + mouseButton));
        textComponent.setTooltip("Multiline/nTooltip/nTest");
        TextBoxComponent textBoxComponent = (TextBoxComponent)new TextBoxComponent(0.0f, 120.0f, 600.0f, 30, "").centerHorizontally();
        textBoxComponent.setShadowText("Click me and enter some text...");
        textBoxComponent.setOnChangedCallback(text -> System.out.println("Text set to " + text));
        BrowsableTextBoxComponent browsableTextBoxComponent = (BrowsableTextBoxComponent)new BrowsableTextBoxComponent(0.0f, textBoxComponent.getY() + textBoxComponent.getHeight() + 10.0f, 600.0f, 30, "").centerHorizontally();
        browsableTextBoxComponent.setReadOnly(false);
        browsableTextBoxComponent.setShadowText("Click the ... to select a path");
        ComboBoxComponent comboBoxComponent = (ComboBoxComponent)new ComboBoxComponent(0.0f, browsableTextBoxComponent.getY() + browsableTextBoxComponent.getHeight() + 10.0f, 600.0f, 30, "Hello", "World", "Item 3").centerHorizontally();
        comboBoxComponent.updateItems("Item 1", "Item 2", "Item 3");
        comboBoxComponent.setItemChangedCallback(selectedItem -> System.out.println("Selected item " + selectedItem));
        CheckBoxComponent checkBoxComponent = (CheckBoxComponent)new CheckBoxComponent(0.0f, comboBoxComponent.getY() + comboBoxComponent.getHeight() + 10.0f, "Check me!", 30).centerHorizontally();
        checkBoxComponent.setOnCheckCallback(checked -> System.out.println("Checkbox was set to " + checked));
        System.out.println(checkBoxComponent.isChecked());
        TextureComponent textureComponent = (TextureComponent)new TextureComponent(0.0f, comboBoxComponent.getY() + comboBoxComponent.getHeight() + 10.0f, "/assets/logo.png", 15, mouseButton -> System.out.println("Image clicked!")).centerHorizontally(200.0f);
        ButtonComponent themeButton = new ButtonComponent(0.0f, Main.getWindow().windowHeight - 100, 100.0f, 50.0f, "Theme", mouseClicked -> {
            if (ThemeEngine.getTheme() == DefaultThemes.BLUE) {
                ThemeEngine.setTheme(DefaultThemes.WHITE);
            } else {
                ThemeEngine.setTheme(DefaultThemes.BLUE);
            }
        });
        ButtonComponent exitButton = new ButtonComponent(0.0f, Main.getWindow().windowHeight - 100, 100.0f, 50.0f, "Exit", mouseClicked -> Main.getWindow().close());
        themeButton.getOnClickCallbacks().add(mouseButton -> themeButton.setTooltip(ThemeEngine.getTheme().getName()));
        themeButton.centerHorizontally(-100.0f);
        exitButton.centerHorizontally(100.0f);
        this.addComponent(textComponent, textBoxComponent, browsableTextBoxComponent, comboBoxComponent, checkBoxComponent, textureComponent, themeButton);
        this.addComponent(exitButton);
    }
}

