/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.installer.screen.impl.simple;

import java.io.File;
import me.deftware.aristois.installer.jsonbuilder.JsonBuilder;
import me.deftware.aristois.installer.modloader.impl.ForgeInstaller;
import me.deftware.aristois.installer.utils.VersionData;
import me.deftware.installer.Main;
import me.deftware.installer.MinecraftLauncher;
import me.deftware.installer.OSUtils;
import me.deftware.installer.screen.AbstractScreen;
import me.deftware.installer.screen.components.ButtonComponent;
import me.deftware.installer.screen.components.TextComponent;
import me.deftware.installer.screen.impl.WelcomeScreen;

public class InstallingScreen
extends AbstractScreen {
    private VersionData version;
    private String path;
    private String launcher;
    private TextComponent textComponent;
    private TextComponent subText;
    private ButtonComponent button;
    private ButtonComponent launchButton;
    private int count = 0;
    private boolean stopped = false;

    public InstallingScreen(VersionData version, String path, String launcher) {
        this.version = version;
        this.path = path;
        this.launcher = launcher;
    }

    @Override
    public void init() {
        if (OSUtils.isWindows() && this.launcher.toLowerCase().contains("vanilla") && MinecraftLauncher.isRunning()) {
            this.stopped = true;
            MinecraftLauncher.stop();
        }
        this.componentList.clear();
        this.textComponent = new TextComponent(0.0f, 0.0f, 40, "Greatness is coming!");
        this.textComponent.centerHorizontally().centerVertically(-20.0f);
        this.subText = new TextComponent(0.0f, this.textComponent.getY() + this.textComponent.getHeight() + 10.0f, 30, "Aristois is being installed...");
        this.subText.centerHorizontally();
        this.button = new ButtonComponent(0.0f, Main.getWindow().windowHeight - 110, 220.0f, 50.0f, "Install another version", mouseButton -> Main.getWindow().transitionForward(new WelcomeScreen()));
        this.button.setAlpha(1);
        this.button.setVisible(false);
        this.launchButton = new ButtonComponent(0.0f, (float)(Main.getWindow().windowHeight - 110) - this.button.getHeight() - 15.0f, 180.0f, 50.0f, "Launch Minecraft", mouseButton -> {
            if (OSUtils.isWindows()) {
                MinecraftLauncher.start();
                System.exit(0);
            }
        });
        this.launchButton.setAlpha(1);
        this.launchButton.setVisible(false);
        this.addComponent(this.textComponent, this.subText, this.button.centerHorizontally(), this.launchButton.centerHorizontally());
        new Thread(() -> {
            Thread.currentThread().setName("Installer thread");
            String result = "";
            if (this.launcher.toLowerCase().contains("forge")) {
                result = new ForgeInstaller().install(this.version, this.path + File.separator);
            } else {
                JsonBuilder builder = this.version.getBuilder(this.launcher.substring(0, this.launcher.length() - " launcher".length()), this.launcher.substring(0, this.launcher.length() - " launcher".length()));
                result = builder.install(builder.build(this.version), this.version, this.path + File.separator);
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            System.out.println(result);
            this.subText.fadeOut(alpha -> this.fadeIn());
            this.textComponent.fadeOut(alpha -> this.fadeIn());
        }).start();
    }

    private void fadeIn() {
        ++this.count;
        if (this.count == 2) {
            this.textComponent.setText("You're all set!");
            if (this.launcher.toLowerCase().contains("vanilla")) {
                this.subText.setText("Start Minecraft and select", "\"release " + this.version.getVersion() + "-Aristois\"");
            } else if (this.launcher.toLowerCase().contains("forge")) {
                this.subText.setText("Start Minecraft and select", "Forge " + this.version.getVersion() + " to start", "Aristois");
            }
            this.textComponent.centerHorizontally().centerVertically(-60.0f);
            this.subText.center();
            this.subText.setY(this.textComponent.getY() + this.textComponent.getHeight() + 10.0f);
            this.textComponent.fadeIn(aplha -> {
                this.button.setVisible(true);
                this.button.fadeIn(alpha -> {});
                if (OSUtils.isWindows() && this.stopped) {
                    MinecraftLauncher.start();
                } else if (OSUtils.isWindows() && this.launcher.toLowerCase().contains("vanilla") && !MinecraftLauncher.isRunning()) {
                    this.launchButton.setVisible(true);
                    this.launchButton.fadeIn(alpha -> {});
                }
            });
            this.subText.fadeIn(null);
        }
    }
}

