/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.installer.screen.impl.simple.configure;

import java.io.File;
import me.deftware.aristois.installer.InstallerAPI;
import me.deftware.aristois.installer.utils.VersionData;
import me.deftware.installer.Main;
import me.deftware.installer.OSUtils;
import me.deftware.installer.screen.AbstractScreen;
import me.deftware.installer.screen.components.BrowsableTextBoxComponent;
import me.deftware.installer.screen.components.ButtonComponent;
import me.deftware.installer.screen.components.ComboBoxComponent;
import me.deftware.installer.screen.components.TextComponent;
import me.deftware.installer.screen.impl.simple.InstallingScreen;
import me.deftware.installer.screen.impl.simple.TransitionScreen;
import me.deftware.installer.screen.impl.simple.YesNoScreen;
import me.deftware.installer.screen.impl.simple.configure.MultiMCInstanceScreen;

public class LauncherScreen
extends AbstractScreen {
    private String version;

    public LauncherScreen(String version) {
        this.version = version;
    }

    @Override
    public void init() {
        int i;
        this.componentList.clear();
        VersionData data = InstallerAPI.getVersions().get(this.version);
        String[] launchers = new String[data.getLaunchers().size() + data.getModLoaders().size()];
        for (i = 0; i < data.getLaunchers().size(); ++i) {
            launchers[i] = data.getLaunchers().get(i) + " launcher";
        }
        for (i = data.getLaunchers().size(); i < data.getLaunchers().size() + data.getModLoaders().size(); ++i) {
            launchers[i] = data.getModLoaders().get(i - data.getLaunchers().size()) + " mod loader";
        }
        ComboBoxComponent launcherBox = new ComboBoxComponent(0.0f, 240.0f, 600.0f, 30, launchers);
        launcherBox.centerHorizontally();
        BrowsableTextBoxComponent minecraftPath = new BrowsableTextBoxComponent(0.0f, 300.0f, 600.0f, 30, OSUtils.getMCDir());
        minecraftPath.setShadowText("Minecraft path...");
        minecraftPath.centerHorizontally();
        this.addComponent(new TextComponent(0.0f, 65.0f, 40, "Launcher & Directory").centerHorizontally(), new TextComponent(0.0f, 130.0f, 25, "Select your launcher and Minecraft directory.", "Press \"Continue\" for a default installation:").centerHorizontally(), launcherBox, new ButtonComponent(50.0f, 400.0f, 100.0f, 50.0f, "Continue", mouseButton -> {
            String launcher = launcherBox.getSelectedItem();
            if (launcher.toLowerCase().contains("mod loader")) {
                Main.getWindow().transitionForward(new YesNoScreen("Warning! This may cause issues.", confirm -> {
                    if (!confirm.booleanValue()) {
                        Main.getWindow().transitionBackwards(this);
                    } else {
                        Main.getWindow().transitionForward(new InstallingScreen(InstallerAPI.getVersions().get(this.version), minecraftPath.getText(), launcher));
                    }
                }, "Using a custom mod loader is not officially supported", "and you may crash or have stability issues.", "Do not report bugs when using one.", "", "If you still wish to use one, press \"Continue\""));
            } else if (launcher.toLowerCase().contains("multimc")) {
                File instancesFolder = new File(minecraftPath.getText() + File.separator + "instances" + File.separator);
                if (!instancesFolder.exists()) {
                    Main.getWindow().transitionForward(new TransitionScreen("Uh oh! Invalid path :(", button -> Main.getWindow().transitionBackwards(this), 3000, "Please specify a valid MultiMC root directory.", "", "You will be redirected back to select it."));
                } else {
                    Main.getWindow().transitionForward(new MultiMCInstanceScreen(InstallerAPI.getVersions().get(this.version), minecraftPath.getText(), launcher));
                }
            } else {
                File mcDir = new File(minecraftPath.getText());
                boolean proceed = true;
                if (!mcDir.exists()) {
                    proceed = false;
                } else if (!new File(mcDir.getAbsolutePath() + File.separator + "versions" + File.separator).exists()) {
                    proceed = false;
                }
                if (proceed) {
                    Main.getWindow().transitionForward(new InstallingScreen(InstallerAPI.getVersions().get(this.version), minecraftPath.getText(), launcher));
                } else {
                    Main.getWindow().transitionForward(new YesNoScreen("Are you sure this is correct?", confirm -> {
                        if (confirm.booleanValue()) {
                            Main.getWindow().transitionForward(new InstallingScreen(InstallerAPI.getVersions().get(this.version), minecraftPath.getText(), launcher));
                        } else {
                            Main.getWindow().transitionBackwards(this);
                        }
                    }, "The Minecraft directory you have chosen", "does not appear to contain the necessary files required for", "Minecraft to run, do you still want to proceed with this path?"));
                }
            }
        }).centerHorizontally(), minecraftPath);
    }
}

