/*
 * Decompiled with CFR 0.152.
 */
package me.deftware.installer.screen.impl.simple.configure;

import java.io.File;
import java.util.ArrayList;
import java.util.Objects;
import me.deftware.aristois.installer.utils.VersionData;
import me.deftware.installer.Main;
import me.deftware.installer.screen.AbstractScreen;
import me.deftware.installer.screen.components.ButtonComponent;
import me.deftware.installer.screen.components.ComboBoxComponent;
import me.deftware.installer.screen.components.TextComponent;
import me.deftware.installer.screen.impl.simple.InstallingScreen;

public class MultiMCInstanceScreen
extends AbstractScreen {
    private VersionData version;
    private String path;
    private String launcher;

    public MultiMCInstanceScreen(VersionData version, String path, String launcher) {
        this.version = version;
        this.path = path;
        this.launcher = launcher;
    }

    @Override
    public void init() {
        this.componentList.clear();
        ArrayList<String> instanceList = new ArrayList<String>();
        for (String instance : Objects.requireNonNull(new File(this.path + File.separator + "instances" + File.separator).list((current, name) -> new File(current, name).isDirectory()))) {
            if (instance.toLowerCase().contains("temp")) continue;
            instanceList.add(instance);
        }
        ComboBoxComponent instancesBox = new ComboBoxComponent(0.0f, 200.0f, 600.0f, 30, instanceList.toArray(new String[instanceList.size()]));
        instancesBox.centerHorizontally();
        this.addComponent(instancesBox, new TextComponent(0.0f, 65.0f, 40, "MultiMC instance").centerHorizontally(), new TextComponent(0.0f, 130.0f, 25, "Select which MultiMC instance you would like to use Aristois with:").centerHorizontally(), new TextComponent(0.0f, 300.0f, 25, "The instance must be Minecraft version " + this.version.getVersion()).centerHorizontally(), new ButtonComponent(50.0f, 400.0f, 100.0f, 50.0f, "Continue", mouseButton -> Main.getWindow().transitionForward(new InstallingScreen(this.version, this.path + File.separator + "instances" + File.separator + instancesBox.getSelectedItem() + File.separator, this.launcher))).centerHorizontally());
    }
}

