/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import net.optifine.Config;
import net.optifine.CustomGuiProperties;
import net.optifine.override.PlayerControllerOF;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;

public class CustomGuis {
    private static dvp mc = Config.getMinecraft();
    private static PlayerControllerOF playerControllerOF = null;
    private static CustomGuiProperties[][] guiProperties = null;
    public static boolean isChristmas = CustomGuis.isChristmas();

    public static ww getTextureLocation(ww loc) {
        atg entity;
        if (guiProperties == null) {
            return loc;
        }
        eaq screen = CustomGuis.mc.y;
        if (!(screen instanceof ebn)) {
            return loc;
        }
        if (!loc.b().equals("minecraft") || !loc.a().startsWith("textures/gui/")) {
            return loc;
        }
        if (playerControllerOF == null) {
            return loc;
        }
        eji world = CustomGuis.mc.r;
        if (world == null) {
            return loc;
        }
        if (screen instanceof eca) {
            return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.CREATIVE, CustomGuis.mc.s.cR(), (bwt)world, loc, screen);
        }
        if (screen instanceof ecj) {
            return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.INVENTORY, CustomGuis.mc.s.cR(), (bwt)world, loc, screen);
        }
        gg pos = playerControllerOF.getLastClickBlockPos();
        if (pos != null) {
            if (screen instanceof ebp) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.ANVIL, pos, (bwt)world, loc, screen);
            }
            if (screen instanceof ebq) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.BEACON, pos, (bwt)world, loc, screen);
            }
            if (screen instanceof ebu) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.BREWING_STAND, pos, (bwt)world, loc, screen);
            }
            if (screen instanceof ebx) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.CHEST, pos, (bwt)world, loc, screen);
            }
            if (screen instanceof eby) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.CRAFTING, pos, (bwt)world, loc, screen);
            }
            if (screen instanceof ecb) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.DISPENSER, pos, (bwt)world, loc, screen);
            }
            if (screen instanceof ece) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.ENCHANTMENT, pos, (bwt)world, loc, screen);
            }
            if (screen instanceof ecf) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.FURNACE, pos, (bwt)world, loc, screen);
            }
            if (screen instanceof ech) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.HOPPER, pos, (bwt)world, loc, screen);
            }
            if (screen instanceof ecs) {
                return CustomGuis.getTexturePos(CustomGuiProperties.EnumContainer.SHULKER_BOX, pos, (bwt)world, loc, screen);
            }
        }
        if ((entity = playerControllerOF.getLastClickEntity()) != null) {
            if (screen instanceof eci) {
                return CustomGuis.getTextureEntity(CustomGuiProperties.EnumContainer.HORSE, entity, (bwt)world, loc);
            }
            if (screen instanceof ecp) {
                return CustomGuis.getTextureEntity(CustomGuiProperties.EnumContainer.VILLAGER, entity, (bwt)world, loc);
            }
        }
        return loc;
    }

    private static ww getTexturePos(CustomGuiProperties.EnumContainer container, gg pos, bwt blockAccess, ww loc, eaq screen) {
        CustomGuiProperties[] props = guiProperties[container.ordinal()];
        if (props == null) {
            return loc;
        }
        for (int i = 0; i < props.length; ++i) {
            CustomGuiProperties prop = props[i];
            if (!prop.matchesPos(container, pos, blockAccess, screen)) continue;
            return prop.getTextureLocation(loc);
        }
        return loc;
    }

    private static ww getTextureEntity(CustomGuiProperties.EnumContainer container, atg entity, bwt blockAccess, ww loc) {
        CustomGuiProperties[] props = guiProperties[container.ordinal()];
        if (props == null) {
            return loc;
        }
        for (int i = 0; i < props.length; ++i) {
            CustomGuiProperties prop = props[i];
            if (!prop.matchesEntity(container, entity, blockAccess)) continue;
            return prop.getTextureLocation(loc);
        }
        return loc;
    }

    public static void update() {
        guiProperties = null;
        if (!Config.isCustomGuis()) {
            return;
        }
        ArrayList<List<CustomGuiProperties>> listProps = new ArrayList<List<CustomGuiProperties>>();
        acv[] rps = Config.getResourcePacks();
        for (int i = rps.length - 1; i >= 0; --i) {
            acv rp = rps[i];
            CustomGuis.update(rp, listProps);
        }
        guiProperties = CustomGuis.propertyListToArray(listProps);
    }

    private static CustomGuiProperties[][] propertyListToArray(List<List<CustomGuiProperties>> listProps) {
        if (listProps.isEmpty()) {
            return null;
        }
        CustomGuiProperties[][] cgps = new CustomGuiProperties[CustomGuiProperties.EnumContainer.values().length][];
        for (int i = 0; i < cgps.length; ++i) {
            List<CustomGuiProperties> subList;
            if (listProps.size() <= i || (subList = listProps.get(i)) == null) continue;
            CustomGuiProperties[] subArr = subList.toArray(new CustomGuiProperties[subList.size()]);
            cgps[i] = subArr;
        }
        return cgps;
    }

    private static void update(acv rp, List<List<CustomGuiProperties>> listProps) {
        Object[] paths = ResUtils.collectFiles(rp, "optifine/gui/container/", ".properties", null);
        Arrays.sort(paths);
        for (int i = 0; i < paths.length; ++i) {
            Object name = paths[i];
            Config.dbg("CustomGuis: " + (String)name);
            try {
                ww locFile = new ww((String)name);
                InputStream in = rp.a(acw.a, locFile);
                if (in == null) {
                    Config.warn("CustomGuis file not found: " + (String)name);
                    continue;
                }
                PropertiesOrdered props = new PropertiesOrdered();
                props.load(in);
                in.close();
                CustomGuiProperties cgp = new CustomGuiProperties(props, (String)name);
                if (!cgp.isValid((String)name)) continue;
                CustomGuis.addToList(cgp, listProps);
                continue;
            }
            catch (FileNotFoundException e2) {
                Config.warn("CustomGuis file not found: " + (String)name);
                continue;
            }
            catch (Exception e3) {
                e3.printStackTrace();
            }
        }
    }

    private static void addToList(CustomGuiProperties cgp, List<List<CustomGuiProperties>> listProps) {
        if (cgp.getContainer() == null) {
            CustomGuis.warn("Invalid container: " + (Object)((Object)cgp.getContainer()));
            return;
        }
        int indexContainer = cgp.getContainer().ordinal();
        while (listProps.size() <= indexContainer) {
            listProps.add(null);
        }
        List<CustomGuiProperties> subList = listProps.get(indexContainer);
        if (subList == null) {
            subList = new ArrayList<CustomGuiProperties>();
            listProps.set(indexContainer, subList);
        }
        subList.add(cgp);
    }

    public static PlayerControllerOF getPlayerControllerOF() {
        return playerControllerOF;
    }

    public static void setPlayerControllerOF(PlayerControllerOF playerControllerOF) {
        CustomGuis.playerControllerOF = playerControllerOF;
    }

    private static boolean isChristmas() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
    }

    private static void warn(String str) {
        Config.warn("[CustomGuis] " + str);
    }
}

