/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.longs.Long2ByteLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ByteLinkedOpenHashMap;
import java.util.Collection;
import java.util.List;
import net.optifine.Config;
import net.optifine.render.RenderEnv;

public class BlockUtils {
    private static final ThreadLocal<RenderSideCacheKey> threadLocalKey = ThreadLocal.withInitial(() -> new RenderSideCacheKey(null, null, null));
    private static final ThreadLocal<Object2ByteLinkedOpenHashMap<RenderSideCacheKey>> threadLocalMap = ThreadLocal.withInitial(() -> {
        Object2ByteLinkedOpenHashMap<RenderSideCacheKey> object2bytelinkedopenhashmap = new Object2ByteLinkedOpenHashMap<RenderSideCacheKey>(200){

            protected void rehash(int p_rehash_1_) {
            }
        };
        object2bytelinkedopenhashmap.defaultReturnValue((byte)127);
        return object2bytelinkedopenhashmap;
    });

    public static boolean shouldSideBeRendered(ckt blockStateIn, bvu blockReaderIn, gg blockPosIn, gl facingIn, RenderEnv renderEnv) {
        gg posNeighbour = blockPosIn.a(facingIn);
        ckt stateNeighbour = blockReaderIn.a_(posNeighbour);
        if (stateNeighbour.isCacheOpaqueCube()) {
            return false;
        }
        if (blockStateIn.a(stateNeighbour, facingIn)) {
            return false;
        }
        if (stateNeighbour.l()) {
            return BlockUtils.shouldSideBeRenderedCached(blockStateIn, blockReaderIn, blockPosIn, facingIn, renderEnv, stateNeighbour, posNeighbour);
        }
        return true;
    }

    public static boolean shouldSideBeRenderedCached(ckt blockStateIn, bvu blockReaderIn, gg blockPosIn, gl facingIn, RenderEnv renderEnv, ckt stateNeighbourIn, gg posNeighbourIn) {
        long key = (long)blockStateIn.getBlockStateId() << 36 | (long)stateNeighbourIn.getBlockStateId() << 4 | (long)facingIn.ordinal();
        Long2ByteLinkedOpenHashMap map = renderEnv.getRenderSideMap();
        byte b0 = map.getAndMoveToFirst(key);
        if (b0 != 0) {
            return b0 > 0;
        }
        dnt voxelshape = blockStateIn.a(blockReaderIn, blockPosIn, facingIn);
        if (voxelshape.b()) {
            return true;
        }
        dnt voxelshape1 = stateNeighbourIn.a(blockReaderIn, posNeighbourIn, facingIn.f());
        boolean flag = dnq.c((dnt)voxelshape, (dnt)voxelshape1, (dne)dne.e);
        if (map.size() > 400) {
            map.removeLastByte();
        }
        map.putAndMoveToFirst(key, (byte)(flag ? 1 : -1));
        return flag;
    }

    public static int getBlockId(bzp block) {
        return gw.W.a((Object)block);
    }

    public static bzp getBlock(ww loc) {
        if (!gw.W.c(loc)) {
            return null;
        }
        return (bzp)gw.W.a(loc);
    }

    public static int getMetadata(ckt blockState) {
        bzp block = blockState.b();
        cku stateContainer = block.m();
        ImmutableList validStates = stateContainer.a();
        int metadata = validStates.indexOf(blockState);
        return metadata;
    }

    public static int getMetadataCount(bzp block) {
        cku stateContainer = block.m();
        ImmutableList validStates = stateContainer.a();
        return validStates.size();
    }

    public static ckt getBlockState(bzp block, int metadata) {
        cku stateContainer = block.m();
        ImmutableList validStates = stateContainer.a();
        if (metadata < 0 || metadata >= validStates.size()) {
            return null;
        }
        ckt blockState = (ckt)validStates.get(metadata);
        return blockState;
    }

    public static List<ckt> getBlockStates(bzp block) {
        cku stateContainer = block.m();
        ImmutableList validStates = stateContainer.a();
        return validStates;
    }

    public static boolean isFullCube(ckt stateIn, bvu blockReaderIn, gg posIn) {
        return stateIn.isCacheOpaqueCollisionShape();
    }

    public static Collection<clw> getProperties(ckt blockState) {
        return blockState.s();
    }

    public static boolean isPropertyTrue(ckt blockState, clk prop) {
        Boolean value = (Boolean)blockState.t().get((Object)prop);
        return Config.isTrue(value);
    }

    public static boolean isPropertyFalse(ckt blockState, clk prop) {
        Boolean value = (Boolean)blockState.t().get((Object)prop);
        return Config.isFalse(value);
    }

    public static final class RenderSideCacheKey {
        private ckt blockState1;
        private ckt blockState2;
        private gl facing;
        private int hashCode;

        private RenderSideCacheKey(ckt blockState1In, ckt blockState2In, gl facingIn) {
            this.blockState1 = blockState1In;
            this.blockState2 = blockState2In;
            this.facing = facingIn;
        }

        private void init(ckt blockState1In, ckt blockState2In, gl facingIn) {
            this.blockState1 = blockState1In;
            this.blockState2 = blockState2In;
            this.facing = facingIn;
            this.hashCode = 0;
        }

        public RenderSideCacheKey duplicate() {
            return new RenderSideCacheKey(this.blockState1, this.blockState2, this.facing);
        }

        public boolean equals(Object p_equals_1_) {
            if (this == p_equals_1_) {
                return true;
            }
            if (!(p_equals_1_ instanceof RenderSideCacheKey)) {
                return false;
            }
            RenderSideCacheKey block$rendersidecachekey = (RenderSideCacheKey)p_equals_1_;
            return this.blockState1 == block$rendersidecachekey.blockState1 && this.blockState2 == block$rendersidecachekey.blockState2 && this.facing == block$rendersidecachekey.facing;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                this.hashCode = 31 * this.hashCode + this.blockState1.hashCode();
                this.hashCode = 31 * this.hashCode + this.blockState2.hashCode();
                this.hashCode = 31 * this.hashCode + this.facing.hashCode();
            }
            return this.hashCode;
        }
    }
}

